/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.regrowth.config;

import com.mactso.regrowth.config.RegrowthEntitiesManager;
import com.mactso.regrowth.config.WallBiomeDataManager;
import com.mactso.regrowth.config.WallFoundationDataManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="regrowth", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static int aDebugLevel;
    public static double aEatingHeals;
    public static String[] defaultRegrowthMobs;
    public static String defaultRegrowthMobs6464;
    public static String[] defaultWallFoundations;
    public static String defaultWallFoundations6464;
    public static String[] defaultWallBiomeData;
    public static String defaultWallBiomeData6464;
    private static int mushroomDensity;
    private static int mushroomXDensity;
    private static int mushroomZDensity;
    private static double mushroomMinTemp;
    private static double mushroomMaxTemp;

    public static int getaDebugLevel() {
        return aDebugLevel;
    }

    public static void setaDebugLevel(int aDebugLevel) {
        MyConfig.aDebugLevel = aDebugLevel;
    }

    public static double getaEatingHeals() {
        return aEatingHeals;
    }

    public static void setaEatingHeals(double aEatingHeals) {
        MyConfig.aEatingHeals = aEatingHeals;
    }

    public static int getMushroomDensity() {
        return mushroomDensity;
    }

    public static int getMushroomXDensity() {
        return mushroomXDensity;
    }

    public static int getMushroomZDensity() {
        return mushroomZDensity;
    }

    public static double getMushroomMinTemp() {
        return mushroomMinTemp;
    }

    public static double getMushroomMaxTemp() {
        return mushroomMaxTemp;
    }

    public static void debugMsg(int level, String dMsg) {
        if (aDebugLevel > level - 1) {
            System.out.println("L" + level + ":" + dMsg);
        }
    }

    public static void debugMsg(int level, BlockPos pos, String dMsg) {
        if (aDebugLevel > level - 1) {
            System.out.println("L" + level + " (" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + "): " + dMsg);
        }
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            MyConfig.bakeConfig();
            RegrowthEntitiesManager.regrowthMobInit();
            WallFoundationDataManager.wallFoundationsInit();
            WallBiomeDataManager.wallBiomeDataInit();
        }
    }

    public static void pushDebugLevel() {
        MyConfig.COMMON.debugLevel.set((Object)aDebugLevel);
    }

    public static void pushValues() {
        MyConfig.COMMON.defaultRegrowthMobsActual.set((Object)RegrowthEntitiesManager.getRegrowthHashAsString());
        MyConfig.COMMON.defaultWallFoundationsActual.set((Object)WallFoundationDataManager.getWallFoundationHashAsString());
        MyConfig.COMMON.defaultBiomeWallDataActual.set((Object)WallBiomeDataManager.getWallBiomeDataHashAsString());
    }

    public static void bakeConfig() {
        aDebugLevel = (Integer)MyConfig.COMMON.debugLevel.get();
        aEatingHeals = (Double)MyConfig.COMMON.eatingHeals.get();
        mushroomDensity = (Integer)MyConfig.COMMON.mushroomDensity.get();
        mushroomXDensity = (Integer)MyConfig.COMMON.mushroomXDensity.get();
        mushroomZDensity = (Integer)MyConfig.COMMON.mushroomZDensity.get();
        mushroomMinTemp = (Double)MyConfig.COMMON.mushroomMinTemp.get();
        mushroomMaxTemp = (Double)MyConfig.COMMON.mushroomMaxTemp.get();
        defaultRegrowthMobs6464 = (String)MyConfig.COMMON.defaultRegrowthMobsActual.get();
        defaultWallFoundations6464 = (String)MyConfig.COMMON.defaultWallFoundationsActual.get();
        defaultWallBiomeData6464 = (String)MyConfig.COMMON.defaultBiomeWallDataActual.get();
        if (aDebugLevel > 0) {
            System.out.println("Regrowth Debug Level: " + aDebugLevel);
        }
    }

    public static void sendChat(PlayerEntity p, String chatMessage, Color color) {
        StringTextComponent component = new StringTextComponent(chatMessage);
        component.func_150256_b().func_240718_a_(color);
        p.func_145747_a((ITextComponent)component, p.func_110124_au());
    }

    public static void sendBoldChat(PlayerEntity p, String chatMessage, Color color) {
        StringTextComponent component = new StringTextComponent(chatMessage);
        component.func_150256_b().func_240713_a_(Boolean.valueOf(true));
        component.func_150256_b().func_240718_a_(color);
        p.func_145747_a((ITextComponent)component, p.func_110124_au());
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue debugLevel;
        public final ForgeConfigSpec.DoubleValue eatingHeals;
        public final ForgeConfigSpec.IntValue mushroomDensity;
        public final ForgeConfigSpec.IntValue mushroomXDensity;
        public final ForgeConfigSpec.IntValue mushroomZDensity;
        public final ForgeConfigSpec.DoubleValue mushroomMinTemp;
        public final ForgeConfigSpec.DoubleValue mushroomMaxTemp;
        public final ForgeConfigSpec.ConfigValue<String> defaultRegrowthMobsActual;
        public final String defaultRegrowthMobs6464 = "minecraft:cow,both,600.0;minecraft:horse,eat,360.0;minecraft:donkey,eat,360.0;minecraft:sheep,eat,240.0;minecraft:pig,reforest,900.0;minecraft:bee,grow,1000.0;minecraft:chicken,grow,640.0;minecraft:villager,crwvt,5.0;minecraft:creeper,tall,120.0;minecraft:zombie,stumble, 60.0;minecraft:bat,stumble, 60.0;minecraft:skeleton,mushroom, 60.0";
        public final ForgeConfigSpec.ConfigValue<String> defaultWallFoundationsActual;
        public final String defaultWallFoundations6464 = "minecraft:grass_block;minecraft:sand;minecraft:red_sand;minecraft:netherrack;minecraft:sandstone;minecraft:podzol;minecraft:dirt;minecraft:stone;minecraft:coarse_dirt";
        public final ForgeConfigSpec.ConfigValue<String> defaultBiomeWallDataActual;
        public final String defaultBiomeWallData6464 = "Regrowth:default,48,minecraft:cobblestone_wall,minecraft:oak_fence;minecraft:plains,48,minecraft:cobblestone_wall,minecraft:oak_fence;minecraft:desert,48,minecraft:sandstone_wall,minecraft:birch_fence;minecraft:extreme_hills,48,minecraft:cobblestone_wall,minecraft:spruce_fence;minecraft:taiga,48,minecraft:mossy_cobblestone_wall,minecraft:spruce_fence;minecraft:savanna,48,minecraft:stone_brick_wall,minecraft:acacia_fence;minecraft:icy,40,minecraft:diorite_wall,minecraft:spruce_fence;minecraft:the_end,40,minecraft:end_stone_brick_wall,minecraft:birch_fence;minecraft:beach,48,minecraft:sandstone_wall,minecraft:oak_fence;minecraft:forest,48,minecraft:mossy_stone_brick_wall,minecraft:oak_fence;minecraft:mesa,48,minecraft:red_sandstone_wall,minecraft:oak_fence;minecraft:jungle,48,minecraft:granite_wall,minecraft:jungle_fence;minecraft:river,48,minecraft:mossy_cobblestone_wall,minecraft:oak_fence;minecraft:nether,40,minecraft:blackstone_wall,minecraft:nether_brick_fence;Regrowth:minimum,32,regrowth:minimum_wall_size,regrowth:fence_placeholder";

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Regrowth Control Values");
            this.debugLevel = builder.comment("Debug Level: 0 = Off, 1 = Log, 2 = Chat+Log").translation("regrowth.config.debugLevel").defineInRange("debugLevel", () -> 0, 0, 2);
            this.eatingHeals = builder.comment("Eating Heals: 0-No, 1-yes").translation("regrowth.config.eatingHeals").defineInRange("eatingHeals", () -> 0.99, 0.0, 1.0);
            this.mushroomDensity = builder.comment("Mushroom density - 3 dense to 11 sparse to 21 very sparse").translation("regrowth.config.mushroomXDensity ").defineInRange("mushroomXDensity ", () -> 7, 3, 21);
            this.mushroomXDensity = builder.comment("Mushroom X axis density - 3 dense to 11 sparse").translation("regrowth.config.mushroomXDensity ").defineInRange("mushroomXDensity ", () -> 6, 3, 11);
            this.mushroomZDensity = builder.comment("Mushroom Z axis density - 3 dense to 11 sparse").translation("regrowth.config.mushroomZDensity ").defineInRange("mushroomZDensity ", () -> 6, 3, 11);
            this.mushroomMinTemp = builder.comment("Mushroom Minimum Biome Temperature").translation("regrowth.config.mushroomMinTemp").defineInRange("mushroomMinTemp", () -> 0.2, -2.0, 2.0);
            this.mushroomMaxTemp = builder.comment("Mushroom Maximum Biome Temperature").translation("regrowth.config.mushroomMaxTemp").defineInRange("mushroomMaxTemp", () -> 1.2, -2.0, 2.0);
            builder.pop();
            builder.push("Regrowth Mobs 6464");
            this.defaultRegrowthMobsActual = builder.comment("RegrowthMobs String 6464").translation("regrowth.configdefaultRegrowthMobsActual").define("defaultRegrowthMobsActual", (Object)"minecraft:cow,both,600.0;minecraft:horse,eat,360.0;minecraft:donkey,eat,360.0;minecraft:sheep,eat,240.0;minecraft:pig,reforest,900.0;minecraft:bee,grow,1000.0;minecraft:chicken,grow,640.0;minecraft:villager,crwvt,5.0;minecraft:creeper,tall,120.0;minecraft:zombie,stumble, 60.0;minecraft:bat,stumble, 60.0;minecraft:skeleton,mushroom, 60.0");
            builder.pop();
            builder.push("Regrowth Wall Foundations 6464");
            this.defaultWallFoundationsActual = builder.comment("WallFoundations String 6464").translation("regrowth.configdefaultWallFoundationsActual").define("defaultWallFoundationsActual", (Object)"minecraft:grass_block;minecraft:sand;minecraft:red_sand;minecraft:netherrack;minecraft:sandstone;minecraft:podzol;minecraft:dirt;minecraft:stone;minecraft:coarse_dirt");
            builder.pop();
            builder.push("Regrowth Biome Wall Data 6464");
            this.defaultBiomeWallDataActual = builder.comment("Biome Meeting Wall Data String 6464").translation("regrowth.configdefaultBiomeWallDataActual").define("defaultBiomeWallDataActual", (Object)"Regrowth:default,48,minecraft:cobblestone_wall,minecraft:oak_fence;minecraft:plains,48,minecraft:cobblestone_wall,minecraft:oak_fence;minecraft:desert,48,minecraft:sandstone_wall,minecraft:birch_fence;minecraft:extreme_hills,48,minecraft:cobblestone_wall,minecraft:spruce_fence;minecraft:taiga,48,minecraft:mossy_cobblestone_wall,minecraft:spruce_fence;minecraft:savanna,48,minecraft:stone_brick_wall,minecraft:acacia_fence;minecraft:icy,40,minecraft:diorite_wall,minecraft:spruce_fence;minecraft:the_end,40,minecraft:end_stone_brick_wall,minecraft:birch_fence;minecraft:beach,48,minecraft:sandstone_wall,minecraft:oak_fence;minecraft:forest,48,minecraft:mossy_stone_brick_wall,minecraft:oak_fence;minecraft:mesa,48,minecraft:red_sandstone_wall,minecraft:oak_fence;minecraft:jungle,48,minecraft:granite_wall,minecraft:jungle_fence;minecraft:river,48,minecraft:mossy_cobblestone_wall,minecraft:oak_fence;minecraft:nether,40,minecraft:blackstone_wall,minecraft:nether_brick_fence;Regrowth:minimum,32,regrowth:minimum_wall_size,regrowth:fence_placeholder");
            builder.pop();
        }
    }
}

