/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.slimyboyos.events;

import com.blamejared.slimyboyos.capability.SlimeAbsorption;
import com.blamejared.slimyboyos.capability.SlimeAbsorptionCapability;
import com.blamejared.slimyboyos.network.MessageItemPickup;
import com.blamejared.slimyboyos.network.MessageItemSync;
import com.blamejared.slimyboyos.network.PacketHandler;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class CommonEventHandler {
    public static final ResourceLocation SLIMES = new ResourceLocation("forge:slimes");

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living.field_70170_p.field_72995_K || !living.func_70089_S() || !living.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
            return;
        }
        living.getCapability(SlimeAbsorptionCapability.SLIME_ABSORPTION).ifPresent(slimeAbsorption -> {
            if (!slimeAbsorption.getAbsorbedStack().func_190926_b()) {
                return;
            }
            AxisAlignedBB bb = living.func_174813_aQ();
            List list = living.field_70170_p.func_175647_a(ItemEntity.class, bb, item -> item.func_70089_S() && !item.func_174874_s() && !item.func_92059_d().func_190926_b());
            if (!list.isEmpty()) {
                ItemEntity item2 = (ItemEntity)list.get(0);
                ItemStack stack = item2.func_92059_d();
                ItemStack absorbedStack = stack.func_77979_a(1);
                slimeAbsorption.setAbsorbedStack(absorbedStack);
                PacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> ((LivingEvent.LivingUpdateEvent)event).getEntity()), (Object)new MessageItemPickup(item2.func_145782_y(), living.func_145782_y(), absorbedStack.func_77946_l()));
                if (stack.func_190926_b()) {
                    item2.func_70106_y();
                }
            }
        });
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living.field_70170_p.field_72995_K || !living.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            return;
        }
        living.getCapability(SlimeAbsorptionCapability.SLIME_ABSORPTION).ifPresent(slimeAbsorption -> {
            ItemStack stack = slimeAbsorption.getAbsorbedStack();
            if (!stack.func_190926_b()) {
                World world = living.field_70170_p;
                ItemEntity item = new ItemEntity(world, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), stack.func_77946_l());
                item.func_174869_p();
                event.getDrops().add(item);
            }
        });
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity e = (Entity)event.getObject();
        if (e.func_200600_R().getTags().contains(SLIMES)) {
            event.addCapability(SlimeAbsorption.Provider.NAME, (ICapabilityProvider)new SlimeAbsorption.Provider());
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity) || !event.getTarget().func_70089_S()) {
            return;
        }
        event.getTarget().getCapability(SlimeAbsorptionCapability.SLIME_ABSORPTION).ifPresent(slimeAbsorption -> PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new MessageItemSync(event.getTarget().func_145782_y(), slimeAbsorption.getAbsorbedStack())));
    }

    @SubscribeEvent
    public void onCheckDespawn(LivingSpawnEvent.AllowDespawn event) {
        event.getEntity().getCapability(SlimeAbsorptionCapability.SLIME_ABSORPTION).lazyMap(SlimeAbsorption::getAbsorbedStack).filter(stack -> !stack.func_190926_b()).ifPresent(stack -> event.setResult(Event.Result.DENY));
    }
}

