/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.paralithic.eval;

import com.dfsek.paralithic.DynamicClassLoader;
import com.dfsek.paralithic.Expression;
import com.dfsek.paralithic.functions.dynamic.DynamicFunction;
import com.dfsek.paralithic.operations.Operation;
import com.dfsek.paralithic.operations.OperationUtils;
import com.dfsek.terra.lib.asm.ClassWriter;
import com.dfsek.terra.lib.asm.MethodVisitor;
import com.dfsek.terra.lib.commons.io.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class ExpressionBuilder {
    private static int builds = 0;
    private static final boolean DUMP = "true".equals(System.getProperty("ASMDumpClasses"));
    private static final String INTERFACE_CLASS_NAME = Expression.class.getCanonicalName().replace('.', '/');
    private static final String DYNAMIC_FUNCTION_CLASS_NAME = DynamicFunction.class.getCanonicalName().replace('.', '/');
    private final Map<String, DynamicFunction> functions;

    public ExpressionBuilder(Map<String, DynamicFunction> functions) {
        this.functions = functions;
    }

    public Expression get(Operation op) {
        String implementationClassName = INTERFACE_CLASS_NAME + "IMPL_" + builds;
        ClassWriter writer = new ClassWriter(3);
        this.functions.forEach((id, function) -> writer.visitField(1, (String)id, "L" + DYNAMIC_FUNCTION_CLASS_NAME + ";", null, null));
        writer.visit(52, 1, implementationClassName, null, "java/lang/Object", new String[]{INTERFACE_CLASS_NAME});
        MethodVisitor constructor = writer.visitMethod(1, "<init>", "()V", null, null);
        constructor.visitCode();
        constructor.visitVarInsn(25, 0);
        constructor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        constructor.visitInsn(177);
        constructor.visitMaxs(0, 0);
        MethodVisitor absMethod = writer.visitMethod(1, "evaluate", "([D)D", null, null);
        absMethod.visitCode();
        OperationUtils.simplify(op).apply(absMethod, implementationClassName);
        absMethod.visitInsn(175);
        absMethod.visitMaxs(0, 0);
        DynamicClassLoader loader = new DynamicClassLoader();
        byte[] bytes = writer.toByteArray();
        if (DUMP) {
            File dump = new File("./dumps/ExpressionIMPL_" + builds + ".class");
            dump.getParentFile().mkdirs();
            System.out.println("Dumping to " + dump.getAbsolutePath());
            try {
                IOUtils.write(bytes, (OutputStream)new FileOutputStream(dump));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ++builds;
        Class<?> clazz = loader.defineClass(implementationClassName.replace('/', '.'), writer.toByteArray());
        try {
            Object instance = clazz.newInstance();
            for (Map.Entry<String, DynamicFunction> entry : this.functions.entrySet()) {
                clazz.getDeclaredField(entry.getKey()).set(instance, entry.getValue());
            }
            return (Expression)instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

