/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.paralithic.eval.parser;

import com.dfsek.paralithic.Expression;
import com.dfsek.paralithic.eval.ExpressionBuilder;
import com.dfsek.paralithic.eval.ParserUtil;
import com.dfsek.paralithic.eval.parser.NamedConstant;
import com.dfsek.paralithic.eval.parser.Scope;
import com.dfsek.paralithic.eval.tokenizer.ParseError;
import com.dfsek.paralithic.eval.tokenizer.ParseException;
import com.dfsek.paralithic.eval.tokenizer.Position;
import com.dfsek.paralithic.eval.tokenizer.Token;
import com.dfsek.paralithic.eval.tokenizer.Tokenizer;
import com.dfsek.paralithic.functions.Function;
import com.dfsek.paralithic.functions.dynamic.DynamicFunction;
import com.dfsek.paralithic.functions.natives.NativeFunction;
import com.dfsek.paralithic.functions.natives.NativeMath;
import com.dfsek.paralithic.functions.operation.OperationFunction;
import com.dfsek.paralithic.functions.operation.TernaryIfFunction;
import com.dfsek.paralithic.operations.Operation;
import com.dfsek.paralithic.operations.binary.BinaryOperation;
import com.dfsek.paralithic.operations.constant.DoubleConstant;
import com.dfsek.paralithic.operations.special.InvocationVariableOperation;
import com.dfsek.paralithic.operations.special.function.FunctionOperation;
import com.dfsek.paralithic.operations.special.function.NativeFunctionOperation;
import com.dfsek.paralithic.operations.unary.AbsoluteValueOperation;
import com.dfsek.paralithic.operations.unary.NegationOperation;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Parser {
    private final Scope scope;
    private final List<ParseError> errors = new ArrayList<ParseError>();
    private final Tokenizer tokenizer;
    private final Map<String, Function> functionTable = new TreeMap<String, Function>();

    public Parser() {
        this(new StringReader(""), new Scope(), new TreeMap<String, Function>());
    }

    protected Parser(Reader input, Scope scope, Map<String, Function> functionTable) {
        this.registerFunction("sin", NativeMath.SIN);
        this.registerFunction("cos", NativeMath.COS);
        this.registerFunction("tan", NativeMath.TAN);
        this.registerFunction("floor", NativeMath.FLOOR);
        this.registerFunction("ceil", NativeMath.CEIL);
        this.registerFunction("round", NativeMath.ROUND);
        this.registerFunction("pow", NativeMath.POW);
        this.registerFunction("min", NativeMath.MIN);
        this.registerFunction("max", NativeMath.MAX);
        this.registerFunction("sqrt", NativeMath.SQRT);
        this.registerFunction("sinh", NativeMath.SINH);
        this.registerFunction("cosh", NativeMath.COSH);
        this.registerFunction("tanh", NativeMath.TANH);
        this.registerFunction("asin", NativeMath.ASIN);
        this.registerFunction("acos", NativeMath.ACOS);
        this.registerFunction("atan", NativeMath.ATAN);
        this.registerFunction("atan2", NativeMath.ATAN2);
        this.registerFunction("rad", NativeMath.RAD);
        this.registerFunction("deg", NativeMath.DEG);
        this.registerFunction("abs", NativeMath.ABS);
        this.registerFunction("log", NativeMath.LOG);
        this.registerFunction("ln", NativeMath.LN);
        this.registerFunction("exp", NativeMath.EXP);
        this.registerFunction("sign", NativeMath.SIGN);
        this.registerFunction("sigmoid", NativeMath.SIGMOID);
        this.registerFunction("if", new TernaryIfFunction());
        this.scope = scope;
        this.tokenizer = new Tokenizer(input);
        this.tokenizer.setProblemCollector(this.errors);
        this.functionTable.putAll(functionTable);
    }

    public Scope getScope() {
        return this.scope;
    }

    public void registerFunction(String name, Function function) {
        this.functionTable.put(name, function);
    }

    public Expression parse(String input) throws ParseException {
        return new Parser(new StringReader(input), new Scope(), this.functionTable).parse();
    }

    public Expression parse(Reader input) throws ParseException {
        return new Parser(input, new Scope(), this.functionTable).parse();
    }

    public Expression parse(String input, Scope scope) throws ParseException {
        return new Parser(new StringReader(input), scope, this.functionTable).parse();
    }

    public Expression parse(Reader input, Scope scope) throws ParseException {
        return new Parser(input, scope, this.functionTable).parse();
    }

    public Expression parse() throws ParseException {
        Operation result = this.expression();
        if (((Token)this.tokenizer.current()).isNotEnd()) {
            Token token = (Token)this.tokenizer.consume();
            this.errors.add(ParseError.error(token, String.format("Unexpected token: '%s'. Expected an expression.", token.getSource())));
        }
        if (!this.errors.isEmpty()) {
            throw ParseException.create(this.errors);
        }
        TreeMap<String, DynamicFunction> dynamicFunctionMap = new TreeMap<String, DynamicFunction>();
        this.functionTable.forEach((id, f) -> {
            if (f instanceof DynamicFunction) {
                dynamicFunctionMap.put((String)id, (DynamicFunction)f);
            }
        });
        return new ExpressionBuilder(dynamicFunctionMap).get(result);
    }

    protected Operation expression() {
        Operation left = this.relationalExpression();
        if (((Token)this.tokenizer.current()).isSymbol("&&")) {
            this.tokenizer.consume();
            Operation right = this.expression();
            return this.reOrder(left, right, BinaryOperation.Op.AND);
        }
        if (((Token)this.tokenizer.current()).isSymbol("||")) {
            this.tokenizer.consume();
            Operation right = this.expression();
            return this.reOrder(left, right, BinaryOperation.Op.OR);
        }
        return left;
    }

    protected Operation relationalExpression() {
        Operation left = this.term();
        if (((Token)this.tokenizer.current()).isSymbol("<")) {
            this.tokenizer.consume();
            Operation right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.LT);
        }
        if (((Token)this.tokenizer.current()).isSymbol("<=")) {
            this.tokenizer.consume();
            Operation right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.LT_EQ);
        }
        if (((Token)this.tokenizer.current()).isSymbol("=")) {
            this.tokenizer.consume();
            Operation right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.EQ);
        }
        if (((Token)this.tokenizer.current()).isSymbol(">=")) {
            this.tokenizer.consume();
            Operation right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.GT_EQ);
        }
        if (((Token)this.tokenizer.current()).isSymbol(">")) {
            this.tokenizer.consume();
            Operation right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.GT);
        }
        if (((Token)this.tokenizer.current()).isSymbol("!=")) {
            this.tokenizer.consume();
            Operation right = this.relationalExpression();
            return this.reOrder(left, right, BinaryOperation.Op.NEQ);
        }
        return left;
    }

    protected Operation term() {
        Operation left = this.product();
        if (((Token)this.tokenizer.current()).isSymbol("+")) {
            this.tokenizer.consume();
            Operation right = this.term();
            return this.reOrder(left, right, BinaryOperation.Op.ADD);
        }
        if (((Token)this.tokenizer.current()).isSymbol("-")) {
            this.tokenizer.consume();
            Operation right = this.term();
            return this.reOrder(left, right, BinaryOperation.Op.SUBTRACT);
        }
        if (((Token)this.tokenizer.current()).isNumber() && ((Token)this.tokenizer.current()).getContents().startsWith("-")) {
            Operation right = this.term();
            return this.reOrder(left, right, BinaryOperation.Op.ADD);
        }
        return left;
    }

    protected Operation product() {
        Operation left = this.power();
        if (((Token)this.tokenizer.current()).isSymbol("*")) {
            this.tokenizer.consume();
            Operation right = this.product();
            return this.reOrder(left, right, BinaryOperation.Op.MULTIPLY);
        }
        if (((Token)this.tokenizer.current()).isSymbol("/")) {
            this.tokenizer.consume();
            Operation right = this.product();
            return this.reOrder(left, right, BinaryOperation.Op.DIVIDE);
        }
        if (((Token)this.tokenizer.current()).isSymbol("%")) {
            this.tokenizer.consume();
            Operation right = this.product();
            return this.reOrder(left, right, BinaryOperation.Op.MODULO);
        }
        return left;
    }

    protected Operation reOrder(Operation left, Operation right, BinaryOperation.Op op) {
        BinaryOperation rightOp;
        if (right instanceof BinaryOperation && !(rightOp = (BinaryOperation)right).isSealed() && rightOp.getOp().getPriority() == op.getPriority()) {
            this.replaceLeft(rightOp, left, op);
            return right;
        }
        return ParserUtil.createBinaryOperation(op, left, right);
    }

    protected void replaceLeft(BinaryOperation target, Operation newLeft, BinaryOperation.Op op) {
        BinaryOperation leftOp;
        if (target.getLeft() instanceof BinaryOperation && !(leftOp = (BinaryOperation)target.getLeft()).isSealed() && leftOp.getOp().getPriority() == op.getPriority()) {
            this.replaceLeft(leftOp, newLeft, op);
            return;
        }
        target.setLeft(ParserUtil.createBinaryOperation(op, newLeft, target.getLeft()));
    }

    protected Operation power() {
        Operation left = this.atom();
        if (((Token)this.tokenizer.current()).isSymbol("^") || ((Token)this.tokenizer.current()).isSymbol("**")) {
            this.tokenizer.consume();
            Operation right = this.power();
            return this.reOrder(left, right, BinaryOperation.Op.POWER);
        }
        return left;
    }

    protected Operation atom() {
        if (((Token)this.tokenizer.current()).isSymbol("-")) {
            this.tokenizer.consume();
            return new NegationOperation(this.atom());
        }
        if (((Token)this.tokenizer.current()).isSymbol("+") && ((Token)this.tokenizer.next()).isSymbol("(")) {
            this.tokenizer.consume();
        }
        if (((Token)this.tokenizer.current()).isSymbol("(")) {
            this.tokenizer.consume();
            Operation result = this.expression();
            if (result instanceof BinaryOperation) {
                ((BinaryOperation)result).seal();
            }
            this.expect(Token.TokenType.SYMBOL, ")");
            return result;
        }
        if (((Token)this.tokenizer.current()).isSymbol("|")) {
            this.tokenizer.consume();
            Operation exp = this.expression();
            this.expect(Token.TokenType.SYMBOL, "|");
            return new AbsoluteValueOperation(exp);
        }
        if (((Token)this.tokenizer.current()).isIdentifier(new String[0])) {
            if (((Token)this.tokenizer.next()).isSymbol("(")) {
                return this.functionCall();
            }
            Token variableName = (Token)this.tokenizer.consume();
            NamedConstant value = this.scope.find(variableName.getContents());
            int index = this.scope.getInvocationVarIndex(variableName.getContents());
            if (index >= 0) {
                return new InvocationVariableOperation(index);
            }
            if (value == null) {
                this.errors.add(ParseError.error(variableName, String.format("Unknown variable: '%s'", variableName.getContents())));
                return new DoubleConstant(0.0);
            }
            return new DoubleConstant(value.getValue());
        }
        return this.literalAtom();
    }

    private Operation literalAtom() {
        if (((Token)this.tokenizer.current()).isSymbol("+") && ((Token)this.tokenizer.next()).isNumber()) {
            this.tokenizer.consume();
        }
        if (((Token)this.tokenizer.current()).isNumber()) {
            double value = Double.parseDouble(((Token)this.tokenizer.consume()).getContents());
            if (((Token)this.tokenizer.current()).is(Token.TokenType.ID)) {
                String quantifier;
                switch (quantifier = ((Token)this.tokenizer.current()).getContents().intern()) {
                    case "n": {
                        value /= 1.0E9;
                        this.tokenizer.consume();
                        break;
                    }
                    case "u": {
                        value /= 1000000.0;
                        this.tokenizer.consume();
                        break;
                    }
                    case "m": {
                        value /= 1000.0;
                        this.tokenizer.consume();
                        break;
                    }
                    case "K": 
                    case "k": {
                        value *= 1000.0;
                        this.tokenizer.consume();
                        break;
                    }
                    case "M": {
                        value *= 1000000.0;
                        this.tokenizer.consume();
                        break;
                    }
                    case "G": {
                        value *= 1.0E9;
                        this.tokenizer.consume();
                        break;
                    }
                    default: {
                        Token token = (Token)this.tokenizer.consume();
                        this.errors.add(ParseError.error(token, String.format("Unexpected token: '%s'. Expected a valid quantifier.", token.getSource())));
                    }
                }
            }
            return new DoubleConstant(value);
        }
        Token token = (Token)this.tokenizer.consume();
        this.errors.add(ParseError.error(token, String.format("Unexpected token: '%s'. Expected an expression.", token.getSource())));
        return new DoubleConstant(Double.NaN);
    }

    protected Operation functionCall() {
        Token funToken = (Token)this.tokenizer.consume();
        Function fun = this.functionTable.get(funToken.getContents());
        ArrayList<Operation> params = new ArrayList<Operation>();
        this.tokenizer.consume();
        while (!((Token)this.tokenizer.current()).isSymbol(")") && ((Token)this.tokenizer.current()).isNotEnd()) {
            if (!params.isEmpty()) {
                this.expect(Token.TokenType.SYMBOL, ",");
            }
            params.add(this.expression());
        }
        this.expect(Token.TokenType.SYMBOL, ")");
        if (fun == null) {
            this.errors.add(ParseError.error(funToken, String.format("Unknown function: '%s'", funToken.getContents())));
            return new DoubleConstant(Double.NaN);
        }
        if (params.size() != fun.getArgNumber() && fun.getArgNumber() >= 0) {
            this.errors.add(ParseError.error(funToken, String.format("Number of arguments for function '%s' do not match. Expected: %d, Found: %d", funToken.getContents(), fun.getArgNumber(), params.size())));
            return new DoubleConstant(Double.NaN);
        }
        if (fun instanceof DynamicFunction) {
            return new FunctionOperation(params, (DynamicFunction)fun, funToken.getContents());
        }
        if (fun instanceof NativeFunction) {
            return new NativeFunctionOperation((NativeFunction)fun, params);
        }
        if (fun instanceof OperationFunction) {
            return ((OperationFunction)fun).getOperation(params);
        }
        this.errors.add(ParseError.error(funToken, String.format("Unknown function implementation: '%s", fun.getClass().getName())));
        return new DoubleConstant(Double.NaN);
    }

    protected void expect(Token.TokenType type, String trigger) {
        if (((Token)this.tokenizer.current()).matches(type, trigger)) {
            this.tokenizer.consume();
        } else {
            this.errors.add(ParseError.error((Position)this.tokenizer.current(), String.format("Unexpected token '%s'. Expected: '%s'", ((Token)this.tokenizer.current()).getSource(), trigger)));
        }
    }
}

