/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.paralithic.operations;

import com.dfsek.paralithic.operations.Operation;
import com.dfsek.paralithic.operations.Simplifiable;
import com.dfsek.terra.lib.asm.MethodVisitor;

public class OperationUtils {
    public static Operation simplify(Operation in) {
        Simplifiable simplifiable;
        int opCode;
        if (in instanceof Simplifiable && (opCode = (simplifiable = (Simplifiable)((Object)in)).canSimplify()) >= 0) {
            return simplifiable.simplify(opCode);
        }
        return in;
    }

    public static boolean isInt(Class<?> clazz) {
        return Integer.TYPE.equals(clazz);
    }

    public static boolean isDouble(Class<?> clazz) {
        return Double.TYPE.equals(clazz);
    }

    public static boolean isBoolean(Class<?> clazz) {
        return Boolean.TYPE.equals(clazz);
    }

    public static boolean isByte(Class<?> clazz) {
        return Byte.TYPE.equals(clazz);
    }

    public static boolean isShort(Class<?> clazz) {
        return Short.TYPE.equals(clazz);
    }

    public static boolean isLong(Class<?> clazz) {
        return Long.TYPE.equals(clazz);
    }

    public static boolean isChar(Class<?> clazz) {
        return Character.TYPE.equals(clazz);
    }

    public static boolean isFloat(Class<?> clazz) {
        return Float.TYPE.equals(clazz);
    }

    public static boolean isWeakInteger(Class<?> clazz) {
        return OperationUtils.isInt(clazz) || OperationUtils.isByte(clazz) || OperationUtils.isShort(clazz);
    }

    public static char getDescriptorCharacter(Class<?> clazz) {
        if (OperationUtils.isDouble(clazz)) {
            return 'D';
        }
        if (OperationUtils.isInt(clazz)) {
            return 'I';
        }
        if (OperationUtils.isShort(clazz)) {
            return 'S';
        }
        if (OperationUtils.isLong(clazz)) {
            return 'J';
        }
        if (OperationUtils.isByte(clazz)) {
            return 'B';
        }
        if (OperationUtils.isBoolean(clazz)) {
            return 'Z';
        }
        if (OperationUtils.isChar(clazz)) {
            return 'C';
        }
        throw new IllegalArgumentException("Not a primitive type: " + clazz);
    }

    public static void siPush(MethodVisitor visitor, int i) {
        switch (i) {
            case -1: {
                visitor.visitInsn(2);
                return;
            }
            case 0: {
                visitor.visitInsn(3);
                return;
            }
            case 1: {
                visitor.visitInsn(4);
                return;
            }
            case 2: {
                visitor.visitInsn(5);
                return;
            }
            case 3: {
                visitor.visitInsn(6);
                return;
            }
            case 4: {
                visitor.visitInsn(7);
                return;
            }
            case 5: {
                visitor.visitInsn(8);
                return;
            }
        }
        visitor.visitIntInsn(17, i);
    }
}

