/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.paralithic.operations.binary;

import com.dfsek.paralithic.operations.Operation;
import com.dfsek.paralithic.operations.OperationUtils;
import com.dfsek.paralithic.operations.Simplifiable;
import com.dfsek.paralithic.operations.constant.Constant;
import com.dfsek.terra.lib.asm.MethodVisitor;
import org.jetbrains.annotations.NotNull;

public abstract class BinaryOperation
implements Operation,
Simplifiable {
    protected Operation left;
    protected Operation right;
    private boolean sealed = false;

    public BinaryOperation(Operation left, Operation right) {
        this.left = OperationUtils.simplify(left);
        this.right = OperationUtils.simplify(right);
    }

    public abstract void applyOperand(MethodVisitor var1, String var2);

    @Override
    public void apply(@NotNull MethodVisitor visitor, String generatedImplementationName) {
        this.left.apply(visitor, generatedImplementationName);
        this.right.apply(visitor, generatedImplementationName);
        this.applyOperand(visitor, generatedImplementationName);
    }

    public void setLeft(Operation left) {
        this.left = left;
    }

    public void setRight(Operation right) {
        this.right = right;
    }

    public void seal() {
        this.sealed = true;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public int canSimplify() {
        if (this.left instanceof Constant && this.right instanceof Constant) {
            return 1;
        }
        return this.specialSimplify();
    }

    protected int specialSimplify() {
        return -1;
    }

    public Operation getLeft() {
        return this.left;
    }

    public Operation getRight() {
        return this.right;
    }

    public abstract Op getOp();

    public String toString() {
        return "(" + this.left.toString() + this.getOp().toString() + this.right.toString() + ")";
    }

    public static enum Op {
        ADD(3),
        SUBTRACT(3),
        MULTIPLY(4),
        DIVIDE(4),
        MODULO(4),
        POWER(5),
        LT(2),
        LT_EQ(2),
        EQ(2),
        GT_EQ(2),
        GT(2),
        NEQ(2),
        AND(1),
        OR(1);

        private final int priority;

        private Op(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

