/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.paralithic.operations.binary;

import com.dfsek.paralithic.operations.Operation;
import com.dfsek.paralithic.operations.OperationUtils;
import com.dfsek.paralithic.operations.binary.BinaryOperation;
import com.dfsek.paralithic.operations.constant.Constant;

public abstract class CommutativeBinaryOperation
extends BinaryOperation {
    public CommutativeBinaryOperation(Operation left, Operation right) {
        super(left, right);
    }

    @Override
    public int specialSimplify() {
        if (this.left instanceof Constant && this.getClass().isInstance(this.right)) {
            CommutativeBinaryOperation rightBin = (CommutativeBinaryOperation)this.right;
            if (rightBin.left instanceof Constant || rightBin.right instanceof Constant) {
                return 7;
            }
        }
        if (this.getClass().isInstance(this.left) && this.right instanceof Constant) {
            CommutativeBinaryOperation leftBin = (CommutativeBinaryOperation)this.left;
            if (leftBin.left instanceof Constant || leftBin.right instanceof Constant) {
                return 6;
            }
        }
        return -1;
    }

    @Override
    public Operation simplify(int opCode) {
        if (opCode == 6 || opCode == 7) {
            return OperationUtils.simplify(this.merge(opCode));
        }
        return this.constantSimplify();
    }

    private Operation merge(int opCode) {
        if (opCode == 6) {
            CommutativeBinaryOperation leftBin = (CommutativeBinaryOperation)this.left;
            boolean cSide = leftBin.left instanceof Constant;
            Operation simplified = OperationUtils.simplify(this.newInstance(cSide ? leftBin.left : leftBin.right, this.right));
            return this.newInstance(cSide ? leftBin.right : leftBin.left, simplified);
        }
        if (opCode == 7) {
            CommutativeBinaryOperation rightBin = (CommutativeBinaryOperation)this.right;
            boolean cSide = rightBin.left instanceof Constant;
            Operation simplified = OperationUtils.simplify(this.newInstance(this.left, cSide ? rightBin.left : rightBin.right));
            return this.newInstance(simplified, cSide ? rightBin.right : rightBin.left);
        }
        throw new IllegalArgumentException("Illegal opcode: " + opCode);
    }

    protected abstract BinaryOperation newInstance(Operation var1, Operation var2);

    public abstract Operation constantSimplify();
}

