/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.paralithic.operations.binary.booleans;

import com.dfsek.paralithic.operations.Operation;
import com.dfsek.paralithic.operations.binary.BinaryOperation;
import com.dfsek.paralithic.operations.constant.DoubleConstant;
import com.dfsek.terra.lib.asm.Label;
import com.dfsek.terra.lib.asm.MethodVisitor;
import org.jetbrains.annotations.NotNull;

public class ComparisonOperation
extends BinaryOperation {
    private final BinaryOperation.Op op;

    public ComparisonOperation(Operation left, Operation right, BinaryOperation.Op op) {
        super(left, right);
        this.op = op;
    }

    private static int toInstruction(BinaryOperation.Op op) {
        switch (op) {
            case EQ: {
                return 153;
            }
            case GT: {
                return 157;
            }
            case LT: {
                return 155;
            }
            case NEQ: {
                return 154;
            }
            case GT_EQ: {
                return 156;
            }
            case LT_EQ: {
                return 158;
            }
        }
        throw new IllegalArgumentException("Not comparison: " + (Object)((Object)op));
    }

    @Override
    public void applyOperand(MethodVisitor visitor, String generatedImplementationName) {
        Label endIf = new Label();
        Label valid = new Label();
        this.left.apply(visitor, generatedImplementationName);
        this.right.apply(visitor, generatedImplementationName);
        visitor.visitInsn(152);
        visitor.visitJumpInsn(ComparisonOperation.toInstruction(this.op), valid);
        visitor.visitInsn(14);
        visitor.visitJumpInsn(167, endIf);
        visitor.visitLabel(valid);
        visitor.visitInsn(15);
        visitor.visitLabel(endIf);
    }

    @Override
    public void apply(@NotNull MethodVisitor visitor, String generatedImplementationName) {
        this.applyOperand(visitor, generatedImplementationName);
    }

    @Override
    public BinaryOperation.Op getOp() {
        return this.op;
    }

    @Override
    public Operation simplify(int opCode) {
        double l = (Double)((DoubleConstant)this.left).getValue();
        double r = (Double)((DoubleConstant)this.right).getValue();
        switch (this.op) {
            case EQ: {
                return new DoubleConstant(l == r ? 1.0 : 0.0);
            }
            case GT: {
                return new DoubleConstant(l > r ? 1.0 : 0.0);
            }
            case LT: {
                return new DoubleConstant(l < r ? 1.0 : 0.0);
            }
            case NEQ: {
                return new DoubleConstant(l != r ? 1.0 : 0.0);
            }
            case GT_EQ: {
                return new DoubleConstant(l >= r ? 1.0 : 0.0);
            }
            case LT_EQ: {
                return new DoubleConstant(l <= r ? 1.0 : 0.0);
            }
        }
        throw new IllegalArgumentException("Not comparison: " + (Object)((Object)this.op));
    }
}

