/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.paralithic.operations.binary.special;

import com.dfsek.paralithic.functions.natives.NativeMath;
import com.dfsek.paralithic.operations.Operation;
import com.dfsek.paralithic.operations.binary.BinaryOperation;
import com.dfsek.paralithic.operations.constant.Constant;
import com.dfsek.paralithic.operations.constant.DoubleConstant;
import com.dfsek.paralithic.operations.special.function.NativeFunctionOperation;
import com.dfsek.terra.lib.asm.MethodVisitor;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class PowerOperation
extends BinaryOperation {
    public PowerOperation(Operation left, Operation right) {
        super(left, right);
    }

    @Override
    public void applyOperand(MethodVisitor visitor, String generatedImplementationName) {
        new NativeFunctionOperation(NativeMath.POW, Arrays.asList(this.left, this.right)).apply(visitor, generatedImplementationName);
    }

    @Override
    public void apply(@NotNull MethodVisitor visitor, String generatedImplementationName) {
        this.applyOperand(visitor, generatedImplementationName);
    }

    @Override
    public BinaryOperation.Op getOp() {
        return BinaryOperation.Op.POWER;
    }

    @Override
    public Operation simplify(int opCode) {
        if (opCode == 3) {
            return new DoubleConstant(1.0);
        }
        if (opCode == 4) {
            return this.right;
        }
        if (opCode == 5) {
            return new NativeFunctionOperation(NativeMath.POW2, Collections.singletonList(this.left));
        }
        return new DoubleConstant(Math.pow((Double)((DoubleConstant)this.left).getValue(), (Double)((DoubleConstant)this.right).getValue()));
    }

    @Override
    protected int specialSimplify() {
        if (this.right instanceof Constant) {
            double pow = (Double)((DoubleConstant)this.right).getValue();
            if (pow == 0.0) {
                return 3;
            }
            if (pow == 1.0) {
                return 4;
            }
            if (pow == 2.0) {
                return 5;
            }
        }
        return -1;
    }
}

