/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.paralithic.operations.special;

import com.dfsek.paralithic.operations.Operation;
import com.dfsek.paralithic.operations.OperationUtils;
import com.dfsek.paralithic.operations.Simplifiable;
import com.dfsek.paralithic.operations.constant.Constant;
import com.dfsek.paralithic.operations.constant.DoubleConstant;
import com.dfsek.terra.lib.asm.Label;
import com.dfsek.terra.lib.asm.MethodVisitor;
import org.jetbrains.annotations.NotNull;

public class TernaryIfOperation
implements Operation,
Simplifiable {
    private final Operation predicate;
    private final Operation left;
    private final Operation right;

    public TernaryIfOperation(Operation predicate, Operation left, Operation right) {
        this.predicate = OperationUtils.simplify(predicate);
        this.left = OperationUtils.simplify(left);
        this.right = OperationUtils.simplify(right);
    }

    @Override
    public void apply(@NotNull MethodVisitor visitor, String generatedImplementationName) {
        Label equal = new Label();
        Label endIf = new Label();
        this.predicate.apply(visitor, generatedImplementationName);
        visitor.visitInsn(14);
        visitor.visitInsn(152);
        visitor.visitJumpInsn(153, equal);
        this.left.apply(visitor, generatedImplementationName);
        visitor.visitJumpInsn(167, endIf);
        visitor.visitLabel(equal);
        this.right.apply(visitor, generatedImplementationName);
        visitor.visitLabel(endIf);
    }

    @Override
    public int canSimplify() {
        if (this.predicate instanceof Constant) {
            return 0;
        }
        return -1;
    }

    @Override
    public Operation simplify(int opCode) {
        return (Double)((DoubleConstant)this.predicate).getValue() != 0.0 ? this.left : this.right;
    }
}

