/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.paralithic.operations.special.function;

import com.dfsek.paralithic.functions.dynamic.DynamicFunction;
import com.dfsek.paralithic.operations.Operation;
import com.dfsek.paralithic.operations.OperationUtils;
import com.dfsek.paralithic.operations.Simplifiable;
import com.dfsek.paralithic.operations.constant.Constant;
import com.dfsek.paralithic.operations.constant.DoubleConstant;
import com.dfsek.terra.lib.asm.MethodVisitor;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FunctionOperation
implements Operation,
Simplifiable {
    private final List<Operation> args;
    private final DynamicFunction function;
    private final String fName;

    public FunctionOperation(List<Operation> args, DynamicFunction function, String fName) {
        this.args = args.stream().map(OperationUtils::simplify).collect(Collectors.toList());
        this.function = function;
        this.fName = fName;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.fName).append('(');
        this.args.forEach(stringBuilder::append);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public void apply(@NotNull MethodVisitor visitor, String generatedImplementationName) {
        visitor.visitVarInsn(25, 0);
        visitor.visitFieldInsn(180, generatedImplementationName, this.fName, "L" + DynamicFunction.class.getCanonicalName().replace('.', '/') + ";");
        OperationUtils.siPush(visitor, this.args.size());
        visitor.visitIntInsn(188, 7);
        for (int i = 0; i < this.args.size(); ++i) {
            visitor.visitInsn(89);
            OperationUtils.siPush(visitor, i);
            this.args.get(i).apply(visitor, generatedImplementationName);
            visitor.visitInsn(82);
        }
        visitor.visitMethodInsn(185, DynamicFunction.class.getCanonicalName().replace('.', '/'), "eval", "([D)D", true);
    }

    @Override
    public int canSimplify() {
        if (this.function.isStateless() && this.args.stream().allMatch(op -> op instanceof Constant)) {
            return 2;
        }
        return -1;
    }

    @Override
    public Operation simplify(int opCode) {
        if (opCode == 2) {
            return new DoubleConstant(this.function.eval(this.args.stream().mapToDouble(op -> (Double)((DoubleConstant)op).getValue()).toArray()));
        }
        return this;
    }
}

