/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.paralithic.operations.special.function;

import com.dfsek.paralithic.functions.natives.NativeFunction;
import com.dfsek.paralithic.operations.Operation;
import com.dfsek.paralithic.operations.OperationUtils;
import com.dfsek.paralithic.operations.Simplifiable;
import com.dfsek.paralithic.operations.constant.Constant;
import com.dfsek.paralithic.operations.constant.DoubleConstant;
import com.dfsek.terra.lib.asm.MethodVisitor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class NativeFunctionOperation
implements Operation,
Simplifiable {
    private final NativeFunction function;
    private final List<Operation> args;

    public NativeFunctionOperation(NativeFunction function, List<Operation> args) {
        this.function = function;
        this.args = args.stream().map(OperationUtils::simplify).collect(Collectors.toList());
    }

    @Override
    public int canSimplify() {
        if (this.args.stream().allMatch(op -> op instanceof Constant) && this.function.isStateless()) {
            return 2;
        }
        return -1;
    }

    @Override
    public Operation simplify(int opCode) {
        Object[] arg = this.args.stream().mapToDouble(op -> (Double)((DoubleConstant)op).getValue()).boxed().toArray();
        try {
            return new DoubleConstant((Double)this.function.getMethod().invoke(null, arg));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void apply(@NotNull MethodVisitor visitor, String generatedImplementationName) {
        Class<?> type;
        Method nativeMethod;
        try {
            nativeMethod = this.function.getMethod();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to fetch native method.", e);
        }
        Parameter[] params = nativeMethod.getParameters();
        if (this.args.size() != params.length) {
            throw new IllegalArgumentException("Arguments do not match. Expected " + params.length + ", found " + this.args.size());
        }
        StringBuilder signature = new StringBuilder("(");
        for (int i = 0; i < params.length; ++i) {
            type = params[i].getType();
            this.args.get(i).apply(visitor, generatedImplementationName);
            if (OperationUtils.isWeakInteger(type)) {
                visitor.visitInsn(135);
            } else if (OperationUtils.isFloat(type)) {
                visitor.visitInsn(141);
            } else if (OperationUtils.isLong(type)) {
                visitor.visitInsn(138);
            } else if (!OperationUtils.isDouble(type)) {
                throw new IllegalArgumentException("Illegal parameter type: " + params[i]);
            }
            signature.append(OperationUtils.getDescriptorCharacter(type));
        }
        signature.append(')');
        int castInsn = Integer.MIN_VALUE;
        type = nativeMethod.getReturnType();
        if (OperationUtils.isWeakInteger(type)) {
            castInsn = 135;
        } else if (OperationUtils.isFloat(type)) {
            castInsn = 141;
        } else if (OperationUtils.isLong(type)) {
            castInsn = 138;
        } else if (!OperationUtils.isDouble(type)) {
            throw new IllegalArgumentException("Illegal return type: " + type);
        }
        signature.append(OperationUtils.getDescriptorCharacter(nativeMethod.getReturnType()));
        visitor.visitMethodInsn(184, nativeMethod.getDeclaringClass().getCanonicalName().replace('.', '/'), nativeMethod.getName(), signature.toString(), false);
        if (castInsn != Integer.MIN_VALUE) {
            visitor.visitInsn(castInsn);
        }
    }
}

