/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.tectonic.abstraction;

import com.dfsek.tectonic.abstraction.AbstractPool;
import com.dfsek.tectonic.abstraction.AbstractValueProvider;
import com.dfsek.tectonic.abstraction.Prototype;
import com.dfsek.tectonic.abstraction.TemplateProvider;
import com.dfsek.tectonic.config.ConfigTemplate;
import com.dfsek.tectonic.config.Configuration;
import com.dfsek.tectonic.config.ValidatedConfigTemplate;
import com.dfsek.tectonic.exception.ConfigException;
import com.dfsek.tectonic.exception.LoadException;
import com.dfsek.tectonic.exception.ValidationException;
import com.dfsek.tectonic.loading.ConfigLoader;
import com.dfsek.tectonic.loading.TypeLoader;
import com.dfsek.tectonic.loading.TypeRegistry;
import com.dfsek.tectonic.loading.object.ObjectTemplate;
import com.dfsek.terra.lib.yaml.snakeyaml.error.YAMLException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AbstractConfigLoader
implements TypeRegistry {
    private final ConfigLoader delegate = new ConfigLoader();

    @Override
    public AbstractConfigLoader registerLoader(Type t, TypeLoader<?> loader) {
        this.delegate.registerLoader(t, (TypeLoader)loader);
        return this;
    }

    @Override
    public <T> AbstractConfigLoader registerLoader(Type t, TemplateProvider<ObjectTemplate<T>> provider) {
        this.delegate.registerLoader(t, (TemplateProvider)provider);
        return this;
    }

    public <E extends ConfigTemplate> List<E> load(List<InputStream> inputStreams, TemplateProvider<E> provider) throws ConfigException {
        return this.loadConfigs(inputStreams.stream().map(Configuration::new).collect(Collectors.toList()), provider);
    }

    public <E extends ConfigTemplate> List<E> loadConfigs(List<Configuration> configurations, TemplateProvider<E> provider) throws ConfigException {
        AbstractPool pool = new AbstractPool();
        for (Configuration config : configurations) {
            try {
                Prototype prototype = new Prototype(config);
                pool.add(prototype);
            }
            catch (YAMLException yAMLException) {
                throw new LoadException("Failed to parse YAML: " + yAMLException.getMessage(), yAMLException);
            }
        }
        pool.loadAll();
        HashMap<Prototype, E> fnlList = new HashMap<Prototype, E>();
        for (Prototype prototype : pool.getPrototypes()) {
            if (prototype.isAbstract()) continue;
            AbstractValueProvider valueProvider = new AbstractValueProvider();
            for (Prototype current = prototype; current != null && !current.isRoot(); current = current.getParent()) {
                valueProvider.add(current.getParent());
            }
            E template = provider.getInstance();
            try {
                this.delegate.load((ConfigTemplate)template, prototype.getConfig(), valueProvider);
            }
            catch (ConfigException e) {
                throw new LoadException("Failed to load config with ID \"" + prototype.getID() + "\": " + e.getMessage(), e);
            }
            fnlList.put(prototype, template);
        }
        for (Map.Entry entry : fnlList.entrySet()) {
            if (!(entry.getValue() instanceof ValidatedConfigTemplate) || ((ValidatedConfigTemplate)entry.getValue()).validate()) continue;
            throw new ValidationException("Failed to validate config \"" + ((Prototype)entry.getKey()).getID() + ". Reason unspecified.");
        }
        return new ArrayList(fnlList.values());
    }
}

