/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.tectonic.abstraction;

import com.dfsek.tectonic.abstraction.AbstractPool;
import com.dfsek.tectonic.abstraction.exception.AbstractionException;
import com.dfsek.tectonic.abstraction.exception.CircularInheritanceException;
import com.dfsek.tectonic.abstraction.exception.ParentNotFoundException;
import com.dfsek.tectonic.annotations.Default;
import com.dfsek.tectonic.annotations.Value;
import com.dfsek.tectonic.config.ConfigTemplate;
import com.dfsek.tectonic.config.Configuration;
import com.dfsek.tectonic.config.ValidatedConfigTemplate;
import com.dfsek.tectonic.exception.ConfigException;
import com.dfsek.tectonic.exception.ValidationException;
import com.dfsek.tectonic.loading.ConfigLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Prototype
implements ValidatedConfigTemplate {
    private final List<Prototype> children = new ArrayList<Prototype>();
    private final Set<Integer> UIDs = new HashSet<Integer>();
    private final Configuration config;
    private Prototype parent;
    private boolean isRoot = false;
    @Value(value="id")
    private String id;
    @Value(value="extends")
    @Default
    private String extend = null;
    @Value(value="abstract")
    @Default
    private boolean isAbstract = false;

    public Prototype(Configuration config) throws ConfigException {
        this.config = config;
        new ConfigLoader().load((ConfigTemplate)this, config);
    }

    @NotNull
    public Configuration getConfig() {
        return this.config;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    protected void build(AbstractPool pool, int chainUID) throws AbstractionException {
        if (this.UIDs.contains(chainUID)) {
            throw new CircularInheritanceException("Circular inheritance detected in config: \"" + this.getID() + "\", extending \"" + this.extend + "\", UID: " + chainUID);
        }
        this.UIDs.add(chainUID);
        if (this.extend != null) {
            Prototype parent = pool.get(this.extend);
            if (parent == null) {
                throw new ParentNotFoundException("No such config \"" + this.extend + "\". Specified as parent of \"" + this.id + "\"");
            }
            this.parent = parent;
            this.parent.build(pool, chainUID);
        } else {
            this.isRoot = true;
        }
    }

    @NotNull
    public String getID() {
        return this.id;
    }

    @Nullable
    public Prototype getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public boolean validate() throws ValidationException {
        if (!this.id.matches("^[a-zA-Z0-9_-]*$")) {
            throw new ValidationException("ID must only contain alphanumeric characters, hyphens, and underscores. \"" + this.id + "\" is not a valid ID.");
        }
        return true;
    }
}

