/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.tectonic.config;

import com.dfsek.terra.lib.yaml.snakeyaml.Yaml;
import java.io.InputStream;
import java.util.Map;

public class Configuration {
    private final Map<String, Object> config;
    private String name;

    public Configuration(InputStream is) {
        this.name = is.toString();
        this.config = (Map)new Yaml().load(is);
    }

    public Configuration(InputStream is, String name) {
        this.name = name;
        this.config = (Map)new Yaml().load(is);
    }

    public Configuration(String yaml) {
        this.config = (Map)new Yaml().load(yaml);
    }

    public Configuration(String yaml, String name) {
        this.name = name;
        this.config = (Map)new Yaml().load(yaml);
    }

    public Configuration(Map<String, Object> map) {
        this.config = map;
    }

    public Configuration(Map<String, Object> map, String name) {
        this.name = name;
        this.config = map;
    }

    public Object get(String key) {
        String[] levels = key.split("\\.");
        Object level = this.config;
        for (String keyLevel : levels) {
            if (!(level instanceof Map)) {
                throw new IllegalArgumentException();
            }
            level = level.get(keyLevel);
        }
        return level;
    }

    public boolean contains(String key) {
        String[] levels = key.split("\\.");
        Object level = this.config;
        for (String keyLevel : levels) {
            if (!(level instanceof Map)) {
                return false;
            }
            level = level.get(keyLevel);
        }
        return level != null;
    }

    public String getName() {
        return this.name;
    }
}

