/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.tectonic.loading;

import com.dfsek.tectonic.abstraction.AbstractValueProvider;
import com.dfsek.tectonic.abstraction.TemplateProvider;
import com.dfsek.tectonic.abstraction.exception.ProviderMissingException;
import com.dfsek.tectonic.annotations.Abstractable;
import com.dfsek.tectonic.annotations.Default;
import com.dfsek.tectonic.annotations.Value;
import com.dfsek.tectonic.config.ConfigTemplate;
import com.dfsek.tectonic.config.Configuration;
import com.dfsek.tectonic.config.ValidatedConfigTemplate;
import com.dfsek.tectonic.exception.ConfigException;
import com.dfsek.tectonic.exception.LoadException;
import com.dfsek.tectonic.exception.ReflectiveAccessException;
import com.dfsek.tectonic.exception.ValidationException;
import com.dfsek.tectonic.exception.ValueMissingException;
import com.dfsek.tectonic.loading.TypeLoader;
import com.dfsek.tectonic.loading.TypeRegistry;
import com.dfsek.tectonic.loading.loaders.StringLoader;
import com.dfsek.tectonic.loading.loaders.generic.ArrayListLoader;
import com.dfsek.tectonic.loading.loaders.generic.HashMapLoader;
import com.dfsek.tectonic.loading.loaders.generic.HashSetLoader;
import com.dfsek.tectonic.loading.loaders.other.DurationLoader;
import com.dfsek.tectonic.loading.loaders.primitives.BooleanLoader;
import com.dfsek.tectonic.loading.loaders.primitives.ByteLoader;
import com.dfsek.tectonic.loading.loaders.primitives.CharLoader;
import com.dfsek.tectonic.loading.loaders.primitives.DoubleLoader;
import com.dfsek.tectonic.loading.loaders.primitives.FloatLoader;
import com.dfsek.tectonic.loading.loaders.primitives.IntLoader;
import com.dfsek.tectonic.loading.loaders.primitives.LongLoader;
import com.dfsek.tectonic.loading.loaders.primitives.ShortLoader;
import com.dfsek.tectonic.loading.object.ObjectTemplate;
import com.dfsek.tectonic.loading.object.ObjectTemplateLoader;
import com.dfsek.tectonic.util.ReflectionUtil;
import com.dfsek.terra.lib.yaml.snakeyaml.error.YAMLException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigLoader
implements TypeRegistry {
    private final Map<Type, TypeLoader<?>> loaders = new HashMap();
    private static final Map<Class<?>, Class<?>> PRIMITIVES = new HashMap();

    public ConfigLoader() {
        this.registerLoader((Type)Boolean.TYPE, (TypeLoader)new BooleanLoader());
        this.registerLoader((Type)((Object)Boolean.class), (TypeLoader)new BooleanLoader());
        this.registerLoader((Type)Byte.TYPE, (TypeLoader)new ByteLoader());
        this.registerLoader((Type)((Object)Byte.class), (TypeLoader)new ByteLoader());
        this.registerLoader((Type)Short.TYPE, (TypeLoader)new ShortLoader());
        this.registerLoader((Type)((Object)Short.class), (TypeLoader)new ShortLoader());
        this.registerLoader((Type)Character.TYPE, (TypeLoader)new CharLoader());
        this.registerLoader((Type)((Object)Character.class), (TypeLoader)new CharLoader());
        this.registerLoader((Type)Integer.TYPE, (TypeLoader)new IntLoader());
        this.registerLoader((Type)((Object)Integer.class), (TypeLoader)new IntLoader());
        this.registerLoader((Type)Long.TYPE, (TypeLoader)new LongLoader());
        this.registerLoader((Type)((Object)Long.class), (TypeLoader)new LongLoader());
        this.registerLoader((Type)Float.TYPE, (TypeLoader)new FloatLoader());
        this.registerLoader((Type)((Object)Float.class), (TypeLoader)new FloatLoader());
        this.registerLoader((Type)Double.TYPE, (TypeLoader)new DoubleLoader());
        this.registerLoader((Type)((Object)Double.class), (TypeLoader)new DoubleLoader());
        this.registerLoader((Type)((Object)String.class), (TypeLoader)new StringLoader());
        this.registerLoader((Type)((Object)ArrayList.class), (TypeLoader)new ArrayListLoader());
        this.registerLoader((Type)((Object)List.class), (TypeLoader)new ArrayListLoader());
        this.registerLoader((Type)((Object)HashMap.class), (TypeLoader)new HashMapLoader());
        this.registerLoader((Type)((Object)Map.class), (TypeLoader)new HashMapLoader());
        this.registerLoader((Type)((Object)HashSet.class), (TypeLoader)new HashSetLoader());
        this.registerLoader((Type)((Object)Set.class), (TypeLoader)new HashSetLoader());
        this.registerLoader((Type)((Object)Duration.class), (TypeLoader)new DurationLoader());
    }

    @Override
    public ConfigLoader registerLoader(Type t, TypeLoader<?> loader) {
        this.loaders.put(t, loader);
        return this;
    }

    @Override
    public <T> ConfigLoader registerLoader(Type t, TemplateProvider<ObjectTemplate<T>> provider) {
        this.loaders.put(t, new ObjectTemplateLoader<T>(provider));
        return this;
    }

    public void load(ConfigTemplate config, InputStream i) throws ConfigException {
        try {
            Configuration configuration = new Configuration(i);
            this.load(config, configuration);
        }
        catch (YAMLException e) {
            throw new LoadException("Failed to parse YAML: " + e.getMessage(), e);
        }
    }

    public void load(ConfigTemplate config, String yaml) throws ConfigException {
        try {
            Configuration configuration = new Configuration(yaml);
            this.load(config, configuration);
        }
        catch (YAMLException e) {
            throw new LoadException("Failed to parse YAML: " + e.getMessage(), e);
        }
    }

    public void load(ConfigTemplate config, Configuration configuration, AbstractValueProvider provider) throws ConfigException {
        for (Field field : ReflectionUtil.getFields(config.getClass())) {
            Type type;
            int m = field.getModifiers();
            if (Modifier.isFinal(m) || Modifier.isStatic(m)) continue;
            field.setAccessible(true);
            boolean abstractable = false;
            boolean defaultable = false;
            Value value = null;
            for (Annotation annotation : field.getAnnotations()) {
                if (annotation instanceof Abstractable) {
                    abstractable = true;
                }
                if (annotation instanceof Default) {
                    defaultable = true;
                }
                if (!(annotation instanceof Value)) continue;
                value = (Value)annotation;
            }
            if (value == null) continue;
            Type raw = type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                raw = ((ParameterizedType)type).getRawType();
            }
            try {
                if (configuration.contains(value.value())) {
                    Object loadedObject = configuration.get(value.value());
                    if (this.loaders.containsKey(raw)) {
                        loadedObject = this.loadType(type, loadedObject);
                    }
                    this.setField(field, config, this.cast(field.getType(), loadedObject));
                    continue;
                }
                if (abstractable) {
                    if (provider == null) {
                        throw new ProviderMissingException("Attempted to load abstract value with no abstract provider registered");
                    }
                    Object abs = provider.get(value.value());
                    if (abs == null) {
                        if (defaultable) continue;
                        throw new ValueMissingException("Value \"" + value.value() + "\" was not found in the provided config, or its parents: " + configuration.getName());
                    }
                    abs = this.loadType(type, abs);
                    this.setField(field, config, this.cast(field.getType(), abs));
                    continue;
                }
                if (defaultable) continue;
                throw new ValueMissingException("Value \"" + value.value() + "\" was not found in the provided config: " + configuration.getName());
            }
            catch (Exception e) {
                throw new LoadException("Failed to load value \"" + value.value() + "\" to field \"" + field.getName() + "\" in config \"" + configuration.getName() + "\": " + e.getMessage(), e);
            }
        }
        if (config instanceof ValidatedConfigTemplate && provider == null && !((ValidatedConfigTemplate)config).validate()) {
            throw new ValidationException("Failed to validate config. Reason unspecified:" + configuration.getName());
        }
    }

    private <T> T cast(Class<T> clazz, Object object) {
        return PRIMITIVES.getOrDefault(clazz, clazz).cast(object);
    }

    private void setField(Field field, Object target, Object value) throws ReflectiveAccessException {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new ReflectiveAccessException("Failed to set field " + field + ".", e);
        }
    }

    public void load(ConfigTemplate config, Configuration configuration) throws ConfigException {
        this.load(config, configuration, null);
    }

    public Object loadType(Type t, Object o) throws LoadException {
        try {
            Type raw = t;
            if (t instanceof ParameterizedType) {
                raw = ((ParameterizedType)t).getRawType();
            }
            if (this.loaders.containsKey(raw)) {
                return this.loaders.get(raw).load(t, o, this);
            }
            return o;
        }
        catch (LoadException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LoadException("Unexpected exception thrown during type loading: " + e.getMessage(), e);
        }
    }

    public <T> T loadClass(Class<T> clazz, Object o) throws LoadException {
        try {
            if (this.loaders.containsKey(clazz)) {
                return this.cast(clazz, this.loaders.get(clazz).load(clazz, o, this));
            }
            return this.cast(clazz, o);
        }
        catch (LoadException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LoadException("Unexpected exception thrown during type loading: " + e.getMessage(), e);
        }
    }

    static {
        PRIMITIVES.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES.put(Byte.TYPE, Byte.class);
        PRIMITIVES.put(Short.TYPE, Short.class);
        PRIMITIVES.put(Character.TYPE, Character.class);
        PRIMITIVES.put(Integer.TYPE, Integer.class);
        PRIMITIVES.put(Long.TYPE, Long.class);
        PRIMITIVES.put(Float.TYPE, Float.class);
        PRIMITIVES.put(Double.TYPE, Double.class);
        PRIMITIVES.put(Void.TYPE, Void.class);
    }
}

