/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.command;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.command.CommandManager;
import com.dfsek.terra.api.command.CommandTemplate;
import com.dfsek.terra.api.command.ExecutionState;
import com.dfsek.terra.api.command.annotation.Argument;
import com.dfsek.terra.api.command.annotation.Command;
import com.dfsek.terra.api.command.annotation.Subcommand;
import com.dfsek.terra.api.command.annotation.Switch;
import com.dfsek.terra.api.command.annotation.inject.ArgumentTarget;
import com.dfsek.terra.api.command.annotation.inject.SwitchTarget;
import com.dfsek.terra.api.command.annotation.type.DebugCommand;
import com.dfsek.terra.api.command.annotation.type.PlayerCommand;
import com.dfsek.terra.api.command.annotation.type.WorldCommand;
import com.dfsek.terra.api.command.arg.ArgumentParser;
import com.dfsek.terra.api.command.exception.CommandException;
import com.dfsek.terra.api.command.exception.ExecutionException;
import com.dfsek.terra.api.command.exception.InvalidArgumentsException;
import com.dfsek.terra.api.command.exception.MalformedCommandException;
import com.dfsek.terra.api.command.exception.SwitchFormatException;
import com.dfsek.terra.api.command.tab.TabCompleter;
import com.dfsek.terra.api.injection.Injector;
import com.dfsek.terra.api.injection.exception.InjectionException;
import com.dfsek.terra.api.platform.CommandSender;
import com.dfsek.terra.api.platform.entity.Player;
import com.dfsek.terra.api.util.ReflectionUtil;
import com.dfsek.terra.lib.jafama.FastMath;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TerraCommandManager
implements CommandManager {
    private final Map<String, CommandHolder> commands = new HashMap<String, CommandHolder>();
    private final Injector<TerraPlugin> pluginInjector;
    private final TerraPlugin main;

    public TerraCommandManager(TerraPlugin main) {
        this.main = main;
        this.pluginInjector = new Injector<TerraPlugin>(main);
        this.pluginInjector.addExplicitTarget(TerraPlugin.class);
    }

    @Override
    public void execute(String commandName, CommandSender sender, List<String> argsIn) throws CommandException {
        if (!this.commands.containsKey(commandName)) {
            throw new InvalidArgumentsException("No such command \"" + commandName + "\"");
        }
        this.execute(this.commands.get(commandName), sender, new ArrayList<String>(argsIn));
    }

    private void execute(CommandHolder commandHolder, CommandSender sender, List<String> args) throws CommandException {
        Class commandClass = commandHolder.clazz;
        if (commandClass.isAnnotationPresent(DebugCommand.class) && !this.main.isDebug()) {
            sender.sendMessage("Command must be executed with debug mode enabled.");
            return;
        }
        if (commandClass.isAnnotationPresent(PlayerCommand.class) && !(sender instanceof Player)) {
            sender.sendMessage("Command must be executed by player.");
            return;
        }
        if (!(!commandClass.isAnnotationPresent(WorldCommand.class) || sender instanceof Player && ((Player)sender).getWorld().isTerraWorld())) {
            sender.sendMessage("Command must be executed in a Terra world.");
            return;
        }
        ArrayList<String> ogArgs = new ArrayList<String>(args);
        ExecutionState state = new ExecutionState(sender);
        if (!commandClass.isAnnotationPresent(Command.class)) {
            this.invoke(commandClass, state, commandHolder);
            return;
        }
        Command command = commandClass.getAnnotation(Command.class);
        if (command.arguments().length == 0 && command.subcommands().length == 0) {
            if (args.isEmpty()) {
                this.invoke(commandClass, state, commandHolder);
                return;
            }
            throw new InvalidArgumentsException("Expected 0 arguments, found " + args.size());
        }
        if (!args.isEmpty() && commandHolder.subcommands.containsKey(args.get(0))) {
            String c = args.get(0);
            args.remove(0);
            this.execute((CommandHolder)commandHolder.subcommands.get(c), sender, args);
            return;
        }
        boolean req = true;
        for (Argument argument : command.arguments()) {
            if (!req && argument.required()) {
                throw new MalformedCommandException("Required arguments must come first! Arguments: " + Arrays.toString(command.arguments()));
            }
            req = argument.required();
            if (args.isEmpty()) {
                if (!req) break;
                throw new InvalidArgumentsException("Invalid arguments: " + ogArgs + ", usage: " + command.usage());
            }
            String arg = args.get(0);
            if (arg.startsWith("-")) {
                if (!req) break;
                throw new InvalidArgumentsException("Switches must come after arguments.");
            }
            state.addArgument(argument.value(), args.remove(0));
        }
        while (!args.isEmpty()) {
            String aSwitch = args.remove(0);
            if (!aSwitch.startsWith("-")) {
                throw new SwitchFormatException("Invalid switch \"" + aSwitch + "\"");
            }
            String val = aSwitch.substring(1);
            if (!commandHolder.switches.containsKey(val)) {
                throw new SwitchFormatException("No such switch \"" + aSwitch + "\"");
            }
            state.addSwitch((String)commandHolder.switches.get(val));
        }
        this.invoke(commandClass, state, commandHolder);
    }

    private void invoke(Class<? extends CommandTemplate> clazz, ExecutionState state, CommandHolder holder) throws CommandException {
        try {
            CommandTemplate template = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.pluginInjector.inject(template);
            for (Field field : ReflectionUtil.getFields(clazz)) {
                if (field.isAnnotationPresent(ArgumentTarget.class)) {
                    ArgumentTarget argumentTarget = field.getAnnotation(ArgumentTarget.class);
                    if (!holder.argumentMap.containsKey(argumentTarget.value())) {
                        throw new MalformedCommandException("Argument Target specifies nonexistent argument \"" + argumentTarget.value() + "\"");
                    }
                    String argument = argumentTarget.value();
                    ArgumentParser<?> argumentParser = ((Argument)holder.argumentMap.get(argumentTarget.value())).argumentParser().getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.pluginInjector.inject(argumentParser);
                    field.setAccessible(true);
                    String value = state.getArgument(argument);
                    if (value == null) {
                        value = ((Argument)holder.argumentMap.get(argumentTarget.value())).defaultValue();
                    }
                    field.set(template, argumentParser.parse(state.getSender(), value));
                }
                if (!field.isAnnotationPresent(SwitchTarget.class)) continue;
                SwitchTarget switchTarget = field.getAnnotation(SwitchTarget.class);
                if (!holder.switches.containsValue(switchTarget.value())) {
                    throw new MalformedCommandException("Switch Target specifies nonexistent switch \"" + switchTarget.value() + "\"");
                }
                if (field.getType() != Boolean.TYPE) {
                    throw new MalformedCommandException("Switch Target must be of type boolean.");
                }
                field.setAccessible(true);
                field.setBoolean(template, state.hasSwitch(switchTarget.value()));
            }
            try {
                template.execute(state.getSender());
            }
            catch (Throwable e) {
                throw new ExecutionException("Failed to execute command: " + e.getMessage(), e);
            }
        }
        catch (InjectionException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MalformedCommandException("Unable to reflectively instantiate command: ", e);
        }
    }

    @Override
    public void register(String name, Class<? extends CommandTemplate> clazz) throws MalformedCommandException {
        this.commands.put(name, new CommandHolder(clazz));
    }

    @Override
    public List<String> tabComplete(String command, CommandSender sender, List<String> args) throws CommandException {
        if (args.isEmpty()) {
            return new ArrayList<String>(this.commands.keySet()).stream().sorted(String::compareTo).collect(Collectors.toList());
        }
        if (!this.commands.containsKey(command)) {
            return Collections.emptyList();
        }
        return this.tabComplete(this.commands.get(command), sender, new ArrayList<String>(args)).stream().filter(s -> s.toLowerCase().startsWith(((String)args.get(args.size() - 1)).toLowerCase())).sorted(String::compareTo).collect(Collectors.toList());
    }

    @Override
    public int getMaxArgumentDepth() {
        int max = 0;
        for (CommandHolder value : this.commands.values()) {
            max = FastMath.max(this.getMaxArgumentDepth(value), max);
        }
        return max;
    }

    private int getMaxArgumentDepth(CommandHolder holder) {
        int max = 0;
        max = FastMath.max(holder.arguments.size() + holder.switchList.size(), max);
        for (CommandHolder value : holder.subcommands.values()) {
            max = FastMath.max(max, this.getMaxArgumentDepth(value) + 1);
        }
        return max;
    }

    private List<String> tabComplete(CommandHolder holder, CommandSender sender, List<String> args) throws CommandException {
        if (args.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.size() == 1) {
            completions.addAll(holder.subcommands.keySet());
        }
        if (holder.subcommands.containsKey(args.get(0))) {
            ArrayList<String> newArgs = new ArrayList<String>(args);
            newArgs.remove(0);
            completions.addAll(this.tabComplete((CommandHolder)holder.subcommands.get(args.get(0)), sender, newArgs));
        }
        try {
            if (args.size() <= holder.arguments.size()) {
                TabCompleter completer = ((Argument)holder.arguments.get(args.size() - 1)).tabCompleter().getConstructor(new Class[0]).newInstance(new Object[0]);
                this.pluginInjector.inject(completer);
                completions.addAll(completer.complete(sender));
            }
        }
        catch (InjectionException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MalformedCommandException("Unable to reflectively instantiate tab-completer: ", e);
        }
        return completions;
    }

    private static final class CommandHolder {
        private final Class<? extends CommandTemplate> clazz;
        private final Map<String, CommandHolder> subcommands = new HashMap<String, CommandHolder>();
        private final Map<String, String> switches = new HashMap<String, String>();
        private final List<Argument> arguments;
        private final List<Switch> switchList;
        private final Map<String, Argument> argumentMap = new HashMap<String, Argument>();

        private CommandHolder(Class<? extends CommandTemplate> clazz) throws MalformedCommandException {
            this.clazz = clazz;
            if (clazz.isAnnotationPresent(Command.class)) {
                Command command = clazz.getAnnotation(Command.class);
                for (Subcommand subcommand : command.subcommands()) {
                    if (this.subcommands.containsKey(subcommand.value())) {
                        throw new MalformedCommandException("Duplicate subcommand: " + subcommand);
                    }
                    CommandHolder holder = new CommandHolder(subcommand.clazz());
                    this.subcommands.put(subcommand.value(), holder);
                    String[] stringArray = subcommand.aliases();
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String alias = stringArray[i];
                        this.subcommands.put(alias, holder);
                    }
                }
                for (Annotation annotation : command.switches()) {
                    if (this.switches.containsKey(annotation.value())) {
                        throw new MalformedCommandException("Duplicate switch: " + annotation);
                    }
                    this.switches.put(annotation.value(), annotation.value());
                    for (String alias : annotation.aliases()) {
                        this.switches.put(alias, annotation.value());
                    }
                }
                for (Annotation annotation : command.arguments()) {
                    if (this.argumentMap.containsKey(annotation.value())) {
                        throw new MalformedCommandException("Duplicate argument: " + annotation);
                    }
                    this.argumentMap.put(annotation.value(), (Argument)annotation);
                }
                this.arguments = Arrays.asList(command.arguments());
                this.switchList = Arrays.asList(command.switches());
            } else {
                this.arguments = Collections.emptyList();
                this.switchList = Collections.emptyList();
            }
        }
    }
}

