/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.event;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.addons.TerraAddon;
import com.dfsek.terra.api.event.EventListener;
import com.dfsek.terra.api.event.EventManager;
import com.dfsek.terra.api.event.annotations.Global;
import com.dfsek.terra.api.event.annotations.Priority;
import com.dfsek.terra.api.event.events.Cancellable;
import com.dfsek.terra.api.event.events.Event;
import com.dfsek.terra.api.event.events.PackEvent;
import com.dfsek.terra.api.util.ReflectionUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TerraEventManager
implements EventManager {
    private final Map<Class<? extends Event>, List<ListenerHolder>> listeners = new HashMap<Class<? extends Event>, List<ListenerHolder>>();
    private final TerraPlugin main;

    public TerraEventManager(TerraPlugin main) {
        this.main = main;
    }

    @Override
    public boolean callEvent(Event event) {
        this.listeners.getOrDefault(event.getClass(), Collections.emptyList()).forEach(listenerHolder -> {
            try {
                if (event instanceof PackEvent && !((ListenerHolder)listenerHolder).global) {
                    PackEvent packEvent = (PackEvent)event;
                    if (packEvent.getPack().getTemplate().getAddons().contains(((ListenerHolder)listenerHolder).addon)) {
                        ((ListenerHolder)listenerHolder).method.invoke((Object)((ListenerHolder)listenerHolder).listener, event);
                    }
                } else {
                    ((ListenerHolder)listenerHolder).method.invoke((Object)((ListenerHolder)listenerHolder).listener, event);
                }
            }
            catch (InvocationTargetException e) {
                StringWriter writer = new StringWriter();
                e.getTargetException().printStackTrace(new PrintWriter(writer));
                this.main.logger().warning("Exception occurred during event handling:");
                this.main.logger().warning(writer.toString());
                this.main.logger().warning("Report this to the maintainers of " + ((ListenerHolder)listenerHolder).method.getName());
            }
            catch (Exception e) {
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                this.main.logger().warning("Exception occurred during event handling:");
                this.main.logger().warning(writer.toString());
                this.main.logger().warning("Report this to the maintainers of " + ((ListenerHolder)listenerHolder).method.getName());
            }
        });
        if (event instanceof Cancellable) {
            return !((Cancellable)event).isCancelled();
        }
        return true;
    }

    @Override
    public void registerListener(TerraAddon addon, EventListener listener) {
        Method[] methods;
        Class<?> listenerClass = listener.getClass();
        for (Method method : methods = ReflectionUtil.getMethods(listenerClass)) {
            Class<?> eventParam;
            if (method.getParameterCount() != 1 || !Event.class.isAssignableFrom(eventParam = method.getParameterTypes()[0])) continue;
            Priority p = method.getAnnotation(Priority.class);
            int priority = p == null ? 0 : p.value();
            method.setAccessible(true);
            List holders = this.listeners.computeIfAbsent(eventParam, e -> new ArrayList());
            holders.add(new ListenerHolder(method, listener, priority, addon, method.getAnnotation(Global.class) != null));
            holders.sort(Comparator.comparingInt(ListenerHolder::getPriority));
        }
    }

    private static final class ListenerHolder {
        private final Method method;
        private final EventListener listener;
        private final int priority;
        private final TerraAddon addon;
        private final boolean global;

        private ListenerHolder(Method method, EventListener listener, int priority, TerraAddon addon, boolean global) {
            this.method = method;
            this.listener = listener;
            this.priority = priority;
            this.addon = addon;
            this.global = global;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

