/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.math;

import com.dfsek.terra.api.math.MathUtil;
import com.dfsek.terra.api.math.vector.Vector3;
import com.dfsek.terra.api.util.FastRandom;
import com.dfsek.terra.api.util.GlueList;
import java.util.Random;

public class GridSpawn {
    private final int separation;
    private final int width;
    private final int salt;

    public GridSpawn(int width, int separation, int salt) {
        this.separation = separation;
        this.width = width;
        this.salt = salt;
    }

    public Vector3 getNearestSpawn(int x, int z, long seed) {
        int structureChunkX = x / (this.width + 2 * this.separation);
        int structureChunkZ = z / (this.width + 2 * this.separation);
        GlueList zones = new GlueList();
        for (int xi = structureChunkX - 1; xi <= structureChunkX + 1; ++xi) {
            for (int zi = structureChunkZ - 1; zi <= structureChunkZ + 1; ++zi) {
                zones.add(this.getChunkSpawn(xi, zi, seed));
            }
        }
        Vector3 shortest = (Vector3)zones.get(0);
        Vector3 compare = new Vector3(x, 0.0, z);
        for (Vector3 v : zones) {
            if (!(compare.distanceSquared(shortest) > compare.distanceSquared(v))) continue;
            shortest = v.clone();
        }
        return shortest;
    }

    public Vector3 getChunkSpawn(int structureChunkX, int structureChunkZ, long seed) {
        FastRandom r = new FastRandom(MathUtil.getCarverChunkSeed(structureChunkX, structureChunkZ, seed + (long)this.salt));
        int offsetX = ((Random)r).nextInt(this.width);
        int offsetZ = ((Random)r).nextInt(this.width);
        int sx = structureChunkX * (this.width + 2 * this.separation) + offsetX;
        int sz = structureChunkZ * (this.width + 2 * this.separation) + offsetZ;
        return new Vector3(sx, 0.0, sz);
    }

    public int getWidth() {
        return this.width;
    }

    public int getSeparation() {
        return this.separation;
    }
}

