/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.math.noise.samplers;

import com.dfsek.terra.api.math.noise.NoiseSampler;

public class DomainWarpedSampler
implements NoiseSampler {
    private final NoiseSampler function;
    private final NoiseSampler warp;
    private final int seed;
    private final double amplitude;

    public DomainWarpedSampler(NoiseSampler function, NoiseSampler warp, int seed, double amplitude) {
        this.function = function;
        this.warp = warp;
        this.seed = seed;
        this.amplitude = amplitude;
    }

    @Override
    public double getNoise(double x, double y) {
        return this.getNoiseSeeded(this.seed, x, y);
    }

    @Override
    public double getNoise(double x, double y, double z) {
        return this.getNoiseSeeded(this.seed, x, y, z);
    }

    @Override
    public double getNoiseSeeded(int seed, double x, double y) {
        return this.function.getNoise(x + this.warp.getNoiseSeeded(seed, x, y) * this.amplitude, y + this.warp.getNoiseSeeded(seed + 1, x, y) * this.amplitude);
    }

    @Override
    public double getNoiseSeeded(int seed, double x, double y, double z) {
        return this.function.getNoise(x + this.warp.getNoiseSeeded(seed, x, y, z) * this.amplitude, y + this.warp.getNoiseSeeded(seed + 1, x, y, z) * this.amplitude, z + this.warp.getNoiseSeeded(seed + 2, x, y, z) * this.amplitude);
    }
}

