/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.math.noise.samplers;

import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.lib.jafama.FastMath;
import java.awt.image.BufferedImage;

public class ImageSampler
implements NoiseSampler {
    private final BufferedImage image;
    private final Channel channel;
    private final double frequency;

    public ImageSampler(BufferedImage image, Channel channel, double frequency) {
        this.image = image;
        this.channel = channel;
        this.frequency = frequency;
    }

    @Override
    public double getNoise(double x, double y) {
        return ((double)this.channel.getChannel(this.image.getRGB(FastMath.floorMod(FastMath.floorToInt(x * this.frequency), this.image.getWidth()), FastMath.floorMod(FastMath.floorToInt(y * this.frequency), this.image.getHeight()))) / 255.0 - 0.5) * 2.0;
    }

    @Override
    public double getNoise(double x, double y, double z) {
        return this.getNoise(x, y);
    }

    @Override
    public double getNoiseSeeded(int seed, double x, double y) {
        return this.getNoise(x, y);
    }

    @Override
    public double getNoiseSeeded(int seed, double x, double y, double z) {
        return this.getNoise(x, y, z);
    }

    public static enum Channel {
        RED{

            @Override
            public int getChannel(int mashed) {
                return mashed >> 16 & 0xFF;
            }
        }
        ,
        GREEN{

            @Override
            public int getChannel(int mashed) {
                return mashed >> 8 & 0xFF;
            }
        }
        ,
        BLUE{

            @Override
            public int getChannel(int mashed) {
                return mashed & 0xFF;
            }
        }
        ,
        GRAYSCALE{

            @Override
            public int getChannel(int mashed) {
                return (RED.getChannel(mashed) + GREEN.getChannel(mashed) + BLUE.getChannel(mashed)) / 3;
            }
        }
        ,
        ALPHA{

            @Override
            public int getChannel(int mashed) {
                return mashed >> 24 & 0xFF;
            }
        };


        public abstract int getChannel(int var1);
    }
}

