/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.math.noise.samplers;

import com.dfsek.terra.api.math.noise.NoiseSampler;

public class KernelSampler
implements NoiseSampler {
    private final double[][] kernel;
    private final NoiseSampler in;
    private double frequency = 1.0;

    public KernelSampler(double[][] kernel, NoiseSampler in) {
        this.kernel = kernel;
        this.in = in;
    }

    @Override
    public double getNoise(double x, double y) {
        return this.getNoiseSeeded(0, x, y);
    }

    @Override
    public double getNoise(double x, double y, double z) {
        return this.getNoiseSeeded(0, x, y, z);
    }

    @Override
    public double getNoiseSeeded(int seed, double x, double y) {
        x *= this.frequency;
        y *= this.frequency;
        double accumulator = 0.0;
        for (int kx = 0; kx < this.kernel.length; ++kx) {
            for (int ky = 0; ky < this.kernel[kx].length; ++ky) {
                accumulator += this.in.getNoise(x + (double)kx, y + (double)ky) * this.kernel[kx][ky];
            }
        }
        return accumulator;
    }

    @Override
    public double getNoiseSeeded(int seed, double x, double y, double z) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        double accumulator = 0.0;
        for (int kx = 0; kx < this.kernel.length; ++kx) {
            for (int ky = 0; ky < this.kernel[kx].length; ++ky) {
                accumulator += this.in.getNoise(x + (double)kx, y, z + (double)ky) * this.kernel[kx][ky];
            }
        }
        return accumulator;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }
}

