/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.math.noise.samplers.noise;

import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.lib.jafama.FastMath;

public abstract class NoiseFunction
implements NoiseSampler {
    protected static final int PRIME_X = 501125321;
    protected static final int PRIME_Y = 1136930381;
    protected static final int PRIME_Z = 1720413743;
    protected double frequency = 0.02;
    protected int seed;
    static final int precision = 100;
    static final int modulus = 36000;
    static final double[] sin = new double[36000];

    public NoiseFunction(int seed) {
        this.seed = seed;
    }

    protected static int fastFloor(double f) {
        return f >= 0.0 ? (int)f : (int)f - 1;
    }

    protected static int hash(int seed, int xPrimed, int yPrimed, int zPrimed) {
        int hash = seed ^ xPrimed ^ yPrimed ^ zPrimed;
        return hash *= 668265261;
    }

    protected static int hash(int seed, int xPrimed, int yPrimed) {
        int hash = seed ^ xPrimed ^ yPrimed;
        return hash *= 668265261;
    }

    protected static int fastRound(double f) {
        return f >= 0.0 ? (int)(f + 0.5) : (int)(f - 0.5);
    }

    protected static double lerp(double a, double b, double t) {
        return a + t * (b - a);
    }

    protected static double interpHermite(double t) {
        return t * t * (3.0 - 2.0 * t);
    }

    protected static double interpQuintic(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    protected static double cubicLerp(double a, double b, double c, double d, double t) {
        double p = d - c - (a - b);
        return t * t * t * p + t * t * (a - b - p) + t * (c - a) + b;
    }

    protected static double fastMin(double a, double b) {
        return a < b ? a : b;
    }

    protected static double fastMax(double a, double b) {
        return a > b ? a : b;
    }

    protected static double fastAbs(double f) {
        return f < 0.0 ? -f : f;
    }

    protected static double fastSqrt(double f) {
        return FastMath.sqrt(f);
    }

    protected static int fastCeil(double f) {
        int i = (int)f;
        if ((double)i < f) {
            ++i;
        }
        return i;
    }

    protected static long murmur64(long h) {
        h ^= h >>> 33;
        h *= -49064778989728563L;
        h ^= h >>> 33;
        h *= -4265267296055464877L;
        h ^= h >>> 33;
        return h;
    }

    private static double sinLookup(int a) {
        return a >= 0 ? sin[a % 36000] : -sin[-a % 36000];
    }

    protected static double fastSin(double a) {
        return NoiseFunction.sinLookup((int)(a * 100.0 + 0.5));
    }

    protected static double fastCos(double a) {
        return NoiseFunction.sinLookup((int)((a + 1.5707963267948966) * 100.0 + 0.5));
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    @Override
    public double getNoise(double x, double y) {
        return this.getNoiseSeeded(this.seed, x, y);
    }

    @Override
    public double getNoise(double x, double y, double z) {
        return this.getNoiseSeeded(this.seed, x, y, z);
    }

    @Override
    public double getNoiseSeeded(int seed, double x, double y) {
        return this.getNoiseRaw(seed, x * this.frequency, y * this.frequency);
    }

    @Override
    public double getNoiseSeeded(int seed, double x, double y, double z) {
        return this.getNoiseRaw(seed, x * this.frequency, y * this.frequency, z * this.frequency);
    }

    public abstract double getNoiseRaw(int var1, double var2, double var4);

    public abstract double getNoiseRaw(int var1, double var2, double var4, double var6);

    static {
        for (int i = 0; i < sin.length; ++i) {
            NoiseFunction.sin[i] = (float)Math.sin((double)i / 100.0);
        }
    }
}

