/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.math.noise.samplers.noise.fractal;

import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.math.noise.samplers.noise.NoiseFunction;

public abstract class FractalNoiseFunction
extends NoiseFunction {
    protected final NoiseSampler input;
    protected double fractalBounding = 0.5714285714285714;
    protected int octaves = 3;
    protected double gain = 0.5;
    protected double lacunarity = 2.0;
    protected double weightedStrength = 0.0;

    public FractalNoiseFunction(int seed, NoiseSampler input) {
        super(seed);
        this.input = input;
        this.frequency = 1.0;
    }

    public void setWeightedStrength(double weightedStrength) {
        this.weightedStrength = weightedStrength;
    }

    protected void calculateFractalBounding() {
        double gain;
        double amp = gain = FractalNoiseFunction.fastAbs(this.gain);
        double ampFractal = 1.0;
        for (int i = 1; i < this.octaves; ++i) {
            ampFractal += amp;
            amp *= gain;
        }
        this.fractalBounding = 1.0 / ampFractal;
    }

    public void setOctaves(int octaves) {
        this.octaves = octaves;
        this.calculateFractalBounding();
    }

    public void setGain(double gain) {
        this.gain = gain;
        this.calculateFractalBounding();
    }

    public void setLacunarity(double lacunarity) {
        this.lacunarity = lacunarity;
    }
}

