/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.math.noise.samplers.noise.fractal;

import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.math.noise.samplers.noise.fractal.FractalNoiseFunction;

public class PingPongSampler
extends FractalNoiseFunction {
    private double pingPongStrength = 2.0;

    public PingPongSampler(int seed, NoiseSampler input) {
        super(seed, input);
    }

    private static double pingPong(double t) {
        return (t -= (double)((int)(t * 0.5) << 1)) < 1.0 ? t : 2.0 - t;
    }

    public void setPingPongStrength(double strength) {
        this.pingPongStrength = strength;
    }

    @Override
    public double getNoiseRaw(int seed, double x, double y) {
        double sum = 0.0;
        double amp = this.fractalBounding;
        for (int i = 0; i < this.octaves; ++i) {
            double noise = PingPongSampler.pingPong((this.input.getNoiseSeeded(seed++, x, y) + 1.0) * this.pingPongStrength);
            sum += (noise - 0.5) * 2.0 * amp;
            amp *= PingPongSampler.lerp(1.0, noise, this.weightedStrength);
            x *= this.lacunarity;
            y *= this.lacunarity;
            amp *= this.gain;
        }
        return sum;
    }

    @Override
    public double getNoiseRaw(int seed, double x, double y, double z) {
        double sum = 0.0;
        double amp = this.fractalBounding;
        for (int i = 0; i < this.octaves; ++i) {
            double noise = PingPongSampler.pingPong((this.input.getNoiseSeeded(seed++, x, y, z) + 1.0) * this.pingPongStrength);
            sum += (noise - 0.5) * 2.0 * amp;
            amp *= PingPongSampler.lerp(1.0, noise, this.weightedStrength);
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            amp *= this.gain;
        }
        return sum;
    }
}

