/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.math.noise.samplers.noise.fractal;

import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.math.noise.samplers.noise.fractal.FractalNoiseFunction;

public class RidgedFractalSampler
extends FractalNoiseFunction {
    public RidgedFractalSampler(int seed, NoiseSampler input) {
        super(seed, input);
    }

    @Override
    public double getNoiseRaw(int seed, double x, double y) {
        double sum = 0.0;
        double amp = this.fractalBounding;
        for (int i = 0; i < this.octaves; ++i) {
            double noise = RidgedFractalSampler.fastAbs(this.input.getNoiseSeeded(seed++, x, y));
            sum += (noise * -2.0 + 1.0) * amp;
            amp *= RidgedFractalSampler.lerp(1.0, 1.0 - noise, this.weightedStrength);
            x *= this.lacunarity;
            y *= this.lacunarity;
            amp *= this.gain;
        }
        return sum;
    }

    @Override
    public double getNoiseRaw(int seed, double x, double y, double z) {
        double sum = 0.0;
        double amp = this.fractalBounding;
        for (int i = 0; i < this.octaves; ++i) {
            double noise = RidgedFractalSampler.fastAbs(this.input.getNoiseSeeded(seed++, x, y, z));
            sum += (noise * -2.0 + 1.0) * amp;
            amp *= RidgedFractalSampler.lerp(1.0, 1.0 - noise, this.weightedStrength);
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            amp *= this.gain;
        }
        return sum;
    }
}

