/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.math.noise.samplers.noise.random;

import com.dfsek.terra.api.math.noise.samplers.noise.NoiseFunction;
import com.dfsek.terra.api.math.noise.samplers.noise.random.WhiteNoiseSampler;

public class GaussianNoiseSampler
extends NoiseFunction {
    private final WhiteNoiseSampler whiteNoiseSampler;

    public GaussianNoiseSampler(int seed) {
        super(seed);
        this.whiteNoiseSampler = new WhiteNoiseSampler(seed);
    }

    @Override
    public double getNoiseRaw(int seed, double x, double y) {
        double v2;
        double v1;
        double s;
        while ((s = (v1 = this.whiteNoiseSampler.getNoiseSeeded(seed++, x, y)) * v1 + (v2 = this.whiteNoiseSampler.getNoiseSeeded(seed++, x, y)) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        return v1 * multiplier;
    }

    @Override
    public double getNoiseRaw(int seed, double x, double y, double z) {
        double v2;
        double v1;
        double s;
        while ((s = (v1 = this.whiteNoiseSampler.getNoiseSeeded(seed++, x, y, z)) * v1 + (v2 = this.whiteNoiseSampler.getNoiseSeeded(seed++, x, y, z)) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        return v1 * multiplier;
    }
}

