/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.math.noise.samplers.noise.simplex;

import com.dfsek.terra.api.math.noise.samplers.noise.simplex.SimplexStyleSampler;

public class OpenSimplex2Sampler
extends SimplexStyleSampler {
    private static final double SQRT3 = 1.7320508075688772;

    public OpenSimplex2Sampler(int seed) {
        super(seed);
    }

    @Override
    public double getNoiseRaw(int seed, double x, double y) {
        double y1;
        double x1;
        double b;
        double n2;
        double G2 = 0.21132486540518713;
        double F2 = 0.3660254037844386;
        double s = (x + y) * 0.3660254037844386;
        int i = OpenSimplex2Sampler.fastFloor(x += s);
        int j = OpenSimplex2Sampler.fastFloor(y += s);
        double xi = x - (double)i;
        double yi = y - (double)j;
        double t = (xi + yi) * 0.21132486540518713;
        double x0 = xi - t;
        double y0 = yi - t;
        double a = 0.5 - x0 * x0 - y0 * y0;
        double n0 = a <= 0.0 ? 0.0 : a * a * (a * a) * OpenSimplex2Sampler.gradCoord(seed, i *= 501125321, j *= 1136930381, x0, y0);
        double c = 3.1547005383792506 * t + (-0.6666666666666666 + a);
        if (c <= 0.0) {
            n2 = 0.0;
        } else {
            double x2 = x0 + -0.5773502691896257;
            double y2 = y0 + -0.5773502691896257;
            n2 = c * c * (c * c) * OpenSimplex2Sampler.gradCoord(seed, i + 501125321, j + 1136930381, x2, y2);
        }
        double n1 = y0 > x0 ? ((b = 0.5 - (x1 = x0 + 0.21132486540518713) * x1 - (y1 = y0 + -0.7886751345948129) * y1) <= 0.0 ? 0.0 : b * b * (b * b) * OpenSimplex2Sampler.gradCoord(seed, i, j + 1136930381, x1, y1)) : ((b = 0.5 - (x1 = x0 + -0.7886751345948129) * x1 - (y1 = y0 + 0.21132486540518713) * y1) <= 0.0 ? 0.0 : b * b * (b * b) * OpenSimplex2Sampler.gradCoord(seed, i + 501125321, j, x1, y1));
        return (n0 + n1 + n2) * 99.83685302734375;
    }

    @Override
    public double getNoiseRaw(int seed, double x, double y, double z) {
        double R3 = 0.6666666666666666;
        double r = (x + y + z) * 0.6666666666666666;
        x = r - x;
        y = r - y;
        z = r - z;
        int i = OpenSimplex2Sampler.fastRound(x);
        int j = OpenSimplex2Sampler.fastRound(y);
        int k = OpenSimplex2Sampler.fastRound(z);
        double x0 = x - (double)i;
        double y0 = y - (double)j;
        double z0 = z - (double)k;
        int xNSign = (int)(-1.0 - x0) | 1;
        int yNSign = (int)(-1.0 - y0) | 1;
        int zNSign = (int)(-1.0 - z0) | 1;
        double ax0 = (double)xNSign * -x0;
        double ay0 = (double)yNSign * -y0;
        double az0 = (double)zNSign * -z0;
        i *= 501125321;
        j *= 1136930381;
        k *= 1720413743;
        double value = 0.0;
        double a = (double)0.6f - x0 * x0 - (y0 * y0 + z0 * z0);
        int l = 0;
        while (true) {
            double b;
            if (a > 0.0) {
                value += a * a * (a * a) * OpenSimplex2Sampler.gradCoord(seed, i, j, k, x0, y0, z0);
            }
            if (ax0 >= ay0 && ax0 >= az0) {
                b = a + ax0 + ax0;
                if (b > 1.0) {
                    value += (b -= 1.0) * b * (b * b) * OpenSimplex2Sampler.gradCoord(seed, i - xNSign * 501125321, j, k, x0 + (double)xNSign, y0, z0);
                }
            } else if (ay0 > ax0 && ay0 >= az0) {
                b = a + ay0 + ay0;
                if (b > 1.0) {
                    value += (b -= 1.0) * b * (b * b) * OpenSimplex2Sampler.gradCoord(seed, i, j - yNSign * 1136930381, k, x0, y0 + (double)yNSign, z0);
                }
            } else {
                b = a + az0 + az0;
                if (b > 1.0) {
                    value += (b -= 1.0) * b * (b * b) * OpenSimplex2Sampler.gradCoord(seed, i, j, k - zNSign * 1720413743, x0, y0, z0 + (double)zNSign);
                }
            }
            if (l == 1) break;
            ax0 = 0.5 - ax0;
            ay0 = 0.5 - ay0;
            az0 = 0.5 - az0;
            x0 = (double)xNSign * ax0;
            y0 = (double)yNSign * ay0;
            z0 = (double)zNSign * az0;
            a += 0.75 - ax0 - (ay0 + az0);
            i += xNSign >> 1 & 0x1DDE90C9;
            j += yNSign >> 1 & 0x43C42E4D;
            k += zNSign >> 1 & 0x668B6E2F;
            xNSign = -xNSign;
            yNSign = -yNSign;
            zNSign = -zNSign;
            seed ^= 0xFFFFFFFF;
            ++l;
        }
        return value * 32.69428253173828;
    }
}

