/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.math.vector;

import com.dfsek.terra.api.math.MathUtil;
import com.dfsek.terra.lib.jafama.FastMath;

public class Vector2
implements Cloneable {
    private double x;
    private double z;

    public Vector2(double x, double z) {
        this.x = x;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public Vector2 setX(double x) {
        this.x = x;
        return this;
    }

    public double getZ() {
        return this.z;
    }

    public Vector2 setZ(double z) {
        this.z = z;
        return this;
    }

    public Vector2 multiply(double m) {
        this.x *= m;
        this.z *= m;
        return this;
    }

    public Vector2 add(Vector2 other) {
        this.x += other.x;
        this.z += other.z;
        return this;
    }

    public Vector2 subtract(Vector2 other) {
        this.x -= other.x;
        this.z -= other.z;
        return this;
    }

    public Vector2 normalize() {
        this.divide(this.length());
        return this;
    }

    public Vector2 divide(double d) {
        this.x /= d;
        this.z /= d;
        return this;
    }

    public double length() {
        return FastMath.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        return this.x * this.x + this.z * this.z;
    }

    public double distance(Vector2 other) {
        return FastMath.sqrt(this.distanceSquared(other));
    }

    public double distanceSquared(Vector2 other) {
        double dx = other.x - this.x;
        double dz = other.z - this.z;
        return dx * dx + dz * dz;
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + Double.hashCode(this.x);
        hash = 31 * hash + Double.hashCode(this.z);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector2)) {
            return false;
        }
        Vector2 other = (Vector2)obj;
        return MathUtil.equals(this.x, other.x) && MathUtil.equals(this.z, other.z);
    }

    public Vector2 clone() {
        try {
            return (Vector2)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public Vector2 add(double x, double z) {
        this.x += x;
        this.z += z;
        return this;
    }

    public int getBlockX() {
        return FastMath.floorToInt(this.x);
    }

    public int getBlockZ() {
        return FastMath.floorToInt(this.z);
    }

    public String toString() {
        return "(" + this.x + ", " + this.z + ")";
    }
}

