/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.math.vector;

import com.dfsek.terra.api.math.MathUtil;
import com.dfsek.terra.api.math.vector.Location;
import com.dfsek.terra.api.math.vector.Vector2;
import com.dfsek.terra.api.platform.world.World;
import com.dfsek.terra.lib.jafama.FastMath;
import org.jetbrains.annotations.NotNull;

public class Vector3
implements Cloneable {
    private double x;
    private double y;
    private double z;

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getZ() {
        return this.z;
    }

    public Vector3 setZ(double z) {
        this.z = z;
        return this;
    }

    public double getX() {
        return this.x;
    }

    public Vector3 setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    public Vector3 setY(double y) {
        this.y = y;
        return this;
    }

    public int getBlockX() {
        return FastMath.floorToInt(this.x);
    }

    public int getBlockY() {
        return FastMath.floorToInt(this.y);
    }

    public int getBlockZ() {
        return FastMath.floorToInt(this.z);
    }

    public Vector3 multiply(double m) {
        this.x *= m;
        this.y *= m;
        this.z *= m;
        return this;
    }

    public Vector3 add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3 add(Vector3 other) {
        this.x += other.getX();
        this.y += other.getY();
        this.z += other.getZ();
        return this;
    }

    public Vector3 add(Vector2 other) {
        this.x += other.getX();
        this.z += other.getZ();
        return this;
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 clone() {
        try {
            return (Vector3)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public double length() {
        return FastMath.sqrt(this.lengthSquared());
    }

    public double inverseLength() {
        return FastMath.invSqrtQuick(this.lengthSquared());
    }

    public boolean isNormalized() {
        return MathUtil.equals(this.lengthSquared(), 1.0);
    }

    @NotNull
    public Vector3 rotateAroundX(double angle) {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        double y = angleCos * this.getY() - angleSin * this.getZ();
        double z = angleSin * this.getY() + angleCos * this.getZ();
        return this.setY(y).setZ(z);
    }

    @NotNull
    public Vector3 rotateAroundY(double angle) {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        double x = angleCos * this.getX() + angleSin * this.getZ();
        double z = -angleSin * this.getX() + angleCos * this.getZ();
        return this.setX(x).setZ(z);
    }

    @NotNull
    public Vector3 rotateAroundZ(double angle) {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        double x = angleCos * this.getX() - angleSin * this.getY();
        double y = angleSin * this.getX() + angleCos * this.getY();
        return this.setX(x).setY(y);
    }

    public double distance(@NotNull Vector3 o) {
        return FastMath.sqrt(FastMath.pow2(this.x - o.x) + FastMath.pow2(this.y - o.y) + FastMath.pow2(this.z - o.z));
    }

    public double distanceSquared(@NotNull Vector3 o) {
        return FastMath.pow2(this.x - o.x) + FastMath.pow2(this.y - o.y) + FastMath.pow2(this.z - o.z);
    }

    @NotNull
    public Vector3 rotateAroundAxis(@NotNull Vector3 axis, double angle) throws IllegalArgumentException {
        return this.rotateAroundNonUnitAxis(axis.isNormalized() ? axis : axis.clone().normalize(), angle);
    }

    @NotNull
    public Vector3 rotateAroundNonUnitAxis(@NotNull Vector3 axis, double angle) throws IllegalArgumentException {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        double x2 = axis.getX();
        double y2 = axis.getY();
        double z2 = axis.getZ();
        double cosTheta = Math.cos(angle);
        double sinTheta = Math.sin(angle);
        double dotProduct = this.dot(axis);
        double xPrime = x2 * dotProduct * (1.0 - cosTheta) + x * cosTheta + (-z2 * y + y2 * z) * sinTheta;
        double yPrime = y2 * dotProduct * (1.0 - cosTheta) + y * cosTheta + (z2 * x - x2 * z) * sinTheta;
        double zPrime = z2 * dotProduct * (1.0 - cosTheta) + z * cosTheta + (-y2 * x + x2 * y) * sinTheta;
        return this.setX(xPrime).setY(yPrime).setZ(zPrime);
    }

    public double dot(@NotNull Vector3 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Location toLocation(World world) {
        return new Location(world, this.clone());
    }

    public Vector3 normalize() {
        return this.multiply(this.inverseLength());
    }

    public Vector3 subtract(int x, int y, int z) {
        this.x -= (double)x;
        this.y -= (double)y;
        this.z -= (double)z;
        return this;
    }

    public Vector3 subtract(Vector3 end) {
        this.x -= end.x;
        this.y -= end.y;
        this.z -= end.z;
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector3)) {
            return false;
        }
        Vector3 other = (Vector3)obj;
        return MathUtil.equals(this.x, other.x) && MathUtil.equals(this.y, other.y) && MathUtil.equals(this.x, other.z);
    }

    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")";
    }
}

