/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.platform.world;

import com.dfsek.terra.api.math.vector.Location;
import com.dfsek.terra.api.platform.Handle;
import com.dfsek.terra.api.platform.block.Block;
import com.dfsek.terra.api.platform.entity.Entity;
import com.dfsek.terra.api.platform.entity.EntityType;
import com.dfsek.terra.api.platform.world.Chunk;
import com.dfsek.terra.api.platform.world.generator.ChunkGenerator;
import com.dfsek.terra.api.platform.world.generator.GeneratorWrapper;
import com.dfsek.terra.api.world.generation.TerraChunkGenerator;

public interface World
extends Handle {
    public long getSeed();

    public int getMaxHeight();

    public ChunkGenerator getGenerator();

    public Chunk getChunkAt(int var1, int var2);

    default public Chunk getChunkAt(Location location) {
        return this.getChunkAt(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public Block getBlockAt(int var1, int var2, int var3);

    default public Block getBlockAt(Location l) {
        return this.getBlockAt(l.getBlockX(), l.getBlockY(), l.getBlockZ());
    }

    public Entity spawnEntity(Location var1, EntityType var2);

    public int getMinHeight();

    default public boolean isTerraWorld() {
        return this.getGenerator().getHandle() instanceof GeneratorWrapper;
    }

    default public TerraChunkGenerator getTerraGenerator() {
        return ((GeneratorWrapper)this.getGenerator().getHandle()).getHandle();
    }
}

