/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.loot;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.platform.inventory.Item;
import com.dfsek.terra.api.platform.inventory.ItemStack;
import com.dfsek.terra.api.structures.loot.functions.AmountFunction;
import com.dfsek.terra.api.structures.loot.functions.DamageFunction;
import com.dfsek.terra.api.structures.loot.functions.EnchantFunction;
import com.dfsek.terra.api.structures.loot.functions.LootFunction;
import com.dfsek.terra.api.util.GlueList;
import com.dfsek.terra.lib.jafama.FastMath;
import com.dfsek.terra.lib.json.simple.JSONArray;
import com.dfsek.terra.lib.json.simple.JSONObject;
import java.util.List;
import java.util.Random;

public class Entry {
    private final Item item;
    private final long weight;
    private final List<LootFunction> functions = new GlueList<LootFunction>();

    public Entry(JSONObject entry, TerraPlugin main) {
        long weight1;
        String id = entry.get("name").toString();
        this.item = main.getItemHandle().createItem(id);
        try {
            weight1 = (Long)entry.get("weight");
        }
        catch (NullPointerException e) {
            weight1 = 1L;
        }
        this.weight = weight1;
        if (entry.containsKey("functions")) {
            for (Object function : (JSONArray)entry.get("functions")) {
                switch ((String)((JSONObject)function).get("function")) {
                    case "minecraft:set_count": 
                    case "set_count": {
                        long min;
                        long max;
                        Object loot = ((JSONObject)function).get("count");
                        if (loot instanceof Long) {
                            max = (Long)loot;
                            min = (Long)loot;
                        } else {
                            max = (Long)((JSONObject)loot).get("max");
                            min = (Long)((JSONObject)loot).get("min");
                        }
                        this.functions.add(new AmountFunction(FastMath.toIntExact(min), FastMath.toIntExact(max)));
                        break;
                    }
                    case "minecraft:set_damage": 
                    case "set_damage": {
                        long maxDamage = (Long)((JSONObject)((JSONObject)function).get("damage")).get("max");
                        long minDamage = (Long)((JSONObject)((JSONObject)function).get("damage")).get("min");
                        this.functions.add(new DamageFunction(FastMath.toIntExact(minDamage), FastMath.toIntExact(maxDamage)));
                        break;
                    }
                    case "minecraft:enchant_with_levels": 
                    case "enchant_with_levels": {
                        long maxEnchant = (Long)((JSONObject)((JSONObject)function).get("levels")).get("max");
                        long minEnchant = (Long)((JSONObject)((JSONObject)function).get("levels")).get("min");
                        JSONArray disabled = null;
                        if (((JSONObject)function).containsKey("disabled_enchants")) {
                            disabled = (JSONArray)((JSONObject)function).get("disabled_enchants");
                        }
                        this.functions.add(new EnchantFunction(FastMath.toIntExact(minEnchant), FastMath.toIntExact(maxEnchant), disabled, main));
                    }
                }
            }
        }
    }

    public ItemStack getItem(Random r) {
        ItemStack item = this.item.newItemStack(1);
        for (LootFunction f : this.functions) {
            item = f.apply(item, r);
        }
        return item;
    }

    public long getWeight() {
        return this.weight;
    }
}

