/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.loot;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.platform.inventory.Inventory;
import com.dfsek.terra.api.platform.inventory.ItemStack;
import com.dfsek.terra.api.structures.loot.Pool;
import com.dfsek.terra.api.util.GlueList;
import com.dfsek.terra.lib.json.simple.JSONArray;
import com.dfsek.terra.lib.json.simple.JSONObject;
import com.dfsek.terra.lib.json.simple.parser.JSONParser;
import com.dfsek.terra.lib.json.simple.parser.ParseException;
import java.util.List;
import java.util.Random;

public class LootTable {
    private final List<Pool> pools = new GlueList<Pool>();

    public LootTable(String json, TerraPlugin main) throws ParseException {
        JSONParser jsonParser = new JSONParser();
        Object tableJSON = jsonParser.parse(json);
        JSONArray poolArray = (JSONArray)((JSONObject)tableJSON).get("pools");
        for (Object pool : poolArray) {
            this.pools.add(new Pool((JSONObject)pool, main));
        }
    }

    public List<ItemStack> getLoot(Random r) {
        GlueList<ItemStack> itemList = new GlueList<ItemStack>();
        for (Pool pool : this.pools) {
            itemList.addAll(pool.getItems(r));
        }
        return itemList;
    }

    public void fillInventory(Inventory i, Random r) {
        List<ItemStack> loot = this.getLoot(r);
        for (ItemStack stack : loot) {
            for (int attempts = 0; stack.getAmount() != 0 && attempts < 10; ++attempts) {
                ItemStack newStack = stack.getType().newItemStack(stack.getAmount());
                newStack.setItemMeta(stack.getItemMeta());
                newStack.setAmount(1);
                int slot = r.nextInt(i.getSize());
                ItemStack slotItem = i.getItem(slot);
                if (slotItem == null) {
                    i.setItem(slot, newStack);
                    stack.setAmount(stack.getAmount() - 1);
                    continue;
                }
                if (!slotItem.getType().equals(newStack.getType())) continue;
                ItemStack dep = newStack.getType().newItemStack(newStack.getAmount());
                dep.setItemMeta(newStack.getItemMeta());
                dep.setAmount(newStack.getAmount() + slotItem.getAmount());
                i.setItem(slot, dep);
                stack.setAmount(stack.getAmount() - 1);
            }
        }
    }
}

