/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.loot;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.platform.inventory.ItemStack;
import com.dfsek.terra.api.structures.loot.Entry;
import com.dfsek.terra.api.util.GlueList;
import com.dfsek.terra.api.util.collections.ProbabilityCollection;
import com.dfsek.terra.lib.jafama.FastMath;
import com.dfsek.terra.lib.json.simple.JSONArray;
import com.dfsek.terra.lib.json.simple.JSONObject;
import java.util.List;
import java.util.Random;

public class Pool {
    private final int max;
    private final int min;
    private final ProbabilityCollection<Entry> entries = new ProbabilityCollection();

    public Pool(JSONObject pool, TerraPlugin main) {
        Object amount = pool.get("rolls");
        if (amount instanceof Long) {
            this.max = FastMath.toIntExact((Long)amount);
            this.min = FastMath.toIntExact((Long)amount);
        } else {
            this.max = FastMath.toIntExact((Long)((JSONObject)amount).get("max"));
            this.min = FastMath.toIntExact((Long)((JSONObject)amount).get("min"));
        }
        for (Object entryJSON : (JSONArray)pool.get("entries")) {
            Entry entry = new Entry((JSONObject)entryJSON, main);
            this.entries.add(entry, FastMath.toIntExact(entry.getWeight()));
        }
    }

    public List<ItemStack> getItems(Random r) {
        int rolls = r.nextInt(this.max - this.min + 1) + this.min;
        GlueList<ItemStack> items = new GlueList<ItemStack>();
        for (int i = 0; i < rolls; ++i) {
            items.add(this.entries.get(r).getItem(r));
        }
        return items;
    }
}

