/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.loot.functions;

import com.dfsek.terra.api.platform.inventory.ItemStack;
import com.dfsek.terra.api.platform.inventory.item.Damageable;
import com.dfsek.terra.api.platform.inventory.item.ItemMeta;
import com.dfsek.terra.api.structures.loot.functions.LootFunction;
import java.util.Random;

public class DamageFunction
implements LootFunction {
    private final int max;
    private final int min;

    public DamageFunction(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public ItemStack apply(ItemStack original, Random r) {
        if (original == null) {
            return null;
        }
        if (!original.isDamageable()) {
            return original;
        }
        ItemMeta meta = original.getItemMeta();
        double itemDurability = r.nextDouble() * (double)(this.max - this.min) + (double)this.min;
        Damageable damage = (Damageable)((Object)meta);
        damage.setDamage((int)(original.getType().getMaxDurability() - itemDurability / 100.0 * original.getType().getMaxDurability()));
        original.setItemMeta((ItemMeta)((Object)damage));
        return original;
    }
}

