/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.loot.functions;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.platform.inventory.ItemStack;
import com.dfsek.terra.api.platform.inventory.item.Enchantment;
import com.dfsek.terra.api.platform.inventory.item.ItemMeta;
import com.dfsek.terra.api.structures.loot.functions.LootFunction;
import com.dfsek.terra.api.util.GlueList;
import com.dfsek.terra.lib.jafama.FastMath;
import com.dfsek.terra.lib.json.simple.JSONArray;
import java.util.Collections;
import java.util.Random;

public class EnchantFunction
implements LootFunction {
    private final int min;
    private final int max;
    private final JSONArray disabled;
    private final TerraPlugin main;

    public EnchantFunction(int min, int max, JSONArray disabled, TerraPlugin main) {
        this.max = max;
        this.min = min;
        this.disabled = disabled;
        this.main = main;
    }

    @Override
    public ItemStack apply(ItemStack original, Random r) {
        if (original.getItemMeta() == null) {
            return original;
        }
        double enchant = r.nextDouble() * (double)(this.max - this.min) + (double)this.min;
        GlueList possible = new GlueList();
        for (Enchantment ench : this.main.getItemHandle().getEnchantments()) {
            if (!ench.canEnchantItem(original) || this.disabled != null && this.disabled.contains(ench.getID())) continue;
            possible.add(ench);
        }
        int numEnchant = r.nextInt((int)FastMath.abs(enchant)) / 10 + 1;
        Collections.shuffle(possible);
        ItemMeta meta = original.getItemMeta();
        block3: for (int i = 0; i < numEnchant && i < possible.size(); ++i) {
            Enchantment chosen = (Enchantment)possible.get(i);
            for (Enchantment ench : meta.getEnchantments().keySet()) {
                if (!chosen.conflictsWith(ench)) continue;
                continue block3;
            }
            int lvl = r.nextInt(1 + (int)((enchant / 40.0 > 1.0 ? 1.0 : enchant / 40.0) * (double)chosen.getMaxLevel()));
            try {
                meta.addEnchantment(chosen, FastMath.max(lvl, 1));
                continue;
            }
            catch (IllegalArgumentException e) {
                this.main.logger().warning("Attempted to enchant " + original.getType() + " with " + chosen + " at level " + FastMath.max(lvl, 1) + ", but an unexpected exception occurred! Usually this is caused by a misbehaving enchantment plugin.");
            }
        }
        original.setItemMeta(meta);
        return original;
    }
}

