/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.parser;

import com.dfsek.terra.api.structures.parser.ParserUtil;
import com.dfsek.terra.api.structures.parser.exceptions.ParseException;
import com.dfsek.terra.api.structures.parser.lang.Block;
import com.dfsek.terra.api.structures.parser.lang.Item;
import com.dfsek.terra.api.structures.parser.lang.Keyword;
import com.dfsek.terra.api.structures.parser.lang.Returnable;
import com.dfsek.terra.api.structures.parser.lang.constants.BooleanConstant;
import com.dfsek.terra.api.structures.parser.lang.constants.ConstantExpression;
import com.dfsek.terra.api.structures.parser.lang.constants.NumericConstant;
import com.dfsek.terra.api.structures.parser.lang.constants.StringConstant;
import com.dfsek.terra.api.structures.parser.lang.functions.Function;
import com.dfsek.terra.api.structures.parser.lang.functions.FunctionBuilder;
import com.dfsek.terra.api.structures.parser.lang.keywords.flow.BreakKeyword;
import com.dfsek.terra.api.structures.parser.lang.keywords.flow.ContinueKeyword;
import com.dfsek.terra.api.structures.parser.lang.keywords.flow.FailKeyword;
import com.dfsek.terra.api.structures.parser.lang.keywords.flow.ReturnKeyword;
import com.dfsek.terra.api.structures.parser.lang.keywords.looplike.ForKeyword;
import com.dfsek.terra.api.structures.parser.lang.keywords.looplike.IfKeyword;
import com.dfsek.terra.api.structures.parser.lang.keywords.looplike.WhileKeyword;
import com.dfsek.terra.api.structures.parser.lang.operations.BinaryOperation;
import com.dfsek.terra.api.structures.parser.lang.operations.BooleanAndOperation;
import com.dfsek.terra.api.structures.parser.lang.operations.BooleanNotOperation;
import com.dfsek.terra.api.structures.parser.lang.operations.BooleanOrOperation;
import com.dfsek.terra.api.structures.parser.lang.operations.ConcatenationOperation;
import com.dfsek.terra.api.structures.parser.lang.operations.DivisionOperation;
import com.dfsek.terra.api.structures.parser.lang.operations.ModuloOperation;
import com.dfsek.terra.api.structures.parser.lang.operations.MultiplicationOperation;
import com.dfsek.terra.api.structures.parser.lang.operations.NegationOperation;
import com.dfsek.terra.api.structures.parser.lang.operations.NumberAdditionOperation;
import com.dfsek.terra.api.structures.parser.lang.operations.SubtractionOperation;
import com.dfsek.terra.api.structures.parser.lang.operations.statements.EqualsStatement;
import com.dfsek.terra.api.structures.parser.lang.operations.statements.GreaterOrEqualsThanStatement;
import com.dfsek.terra.api.structures.parser.lang.operations.statements.GreaterThanStatement;
import com.dfsek.terra.api.structures.parser.lang.operations.statements.LessThanOrEqualsStatement;
import com.dfsek.terra.api.structures.parser.lang.operations.statements.LessThanStatement;
import com.dfsek.terra.api.structures.parser.lang.operations.statements.NotEqualsStatement;
import com.dfsek.terra.api.structures.parser.lang.variables.Assignment;
import com.dfsek.terra.api.structures.parser.lang.variables.Declaration;
import com.dfsek.terra.api.structures.parser.lang.variables.Getter;
import com.dfsek.terra.api.structures.tokenizer.Position;
import com.dfsek.terra.api.structures.tokenizer.Token;
import com.dfsek.terra.api.structures.tokenizer.Tokenizer;
import com.dfsek.terra.api.util.GlueList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Parser {
    private final String data;
    private final Map<String, FunctionBuilder<? extends Function<?>>> functions = new HashMap();
    private String id;

    public Parser(String data) {
        this.data = data;
    }

    public Parser registerFunction(String name, FunctionBuilder<? extends Function<?>> functionBuilder) {
        this.functions.put(name, functionBuilder);
        return this;
    }

    public String getID() {
        return this.id;
    }

    public Block parse() throws ParseException {
        Tokenizer tokens = new Tokenizer(this.data);
        ParserUtil.checkType(tokens.consume(), Token.Type.ID);
        Token idToken = tokens.get();
        ParserUtil.checkType(tokens.consume(), Token.Type.STRING);
        ParserUtil.checkType(tokens.consume(), Token.Type.STATEMENT_END);
        this.id = idToken.getContent();
        return this.parseBlock(tokens, new HashMap<String, Returnable.ReturnType>(), false);
    }

    private Keyword<?> parseLoopLike(Tokenizer tokens, Map<String, Returnable.ReturnType> variableMap, boolean loop) throws ParseException {
        Token identifier = tokens.consume();
        ParserUtil.checkType(identifier, Token.Type.IF_STATEMENT, Token.Type.WHILE_LOOP, Token.Type.FOR_LOOP);
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_BEGIN);
        switch (identifier.getType()) {
            case FOR_LOOP: {
                return this.parseForLoop(tokens, variableMap, identifier.getPosition());
            }
            case IF_STATEMENT: {
                return this.parseIfStatement(tokens, variableMap, identifier.getPosition(), loop);
            }
            case WHILE_LOOP: {
                return this.parseWhileLoop(tokens, variableMap, identifier.getPosition());
            }
        }
        throw new UnsupportedOperationException("Unknown keyword " + identifier.getContent() + ": " + identifier.getPosition());
    }

    private WhileKeyword parseWhileLoop(Tokenizer tokens, Map<String, Returnable.ReturnType> variableMap, Position start) throws ParseException {
        Returnable<Boolean> first = this.parseExpression(tokens, true, variableMap);
        ParserUtil.checkReturnType(first, Returnable.ReturnType.BOOLEAN);
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_END);
        return new WhileKeyword(this.parseStatementBlock(tokens, variableMap, true), first, start);
    }

    private IfKeyword parseIfStatement(Tokenizer tokens, Map<String, Returnable.ReturnType> variableMap, Position start, boolean loop) throws ParseException {
        Returnable<Boolean> condition = this.parseExpression(tokens, true, variableMap);
        ParserUtil.checkReturnType(condition, Returnable.ReturnType.BOOLEAN);
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_END);
        Block elseBlock = null;
        Block statement = this.parseStatementBlock(tokens, variableMap, loop);
        GlueList<IfKeyword.Pair<Returnable<Boolean>, Block>> elseIf = new GlueList<IfKeyword.Pair<Returnable<Boolean>, Block>>();
        while (tokens.hasNext() && tokens.get().getType().equals((Object)Token.Type.ELSE)) {
            tokens.consume();
            if (tokens.get().getType().equals((Object)Token.Type.IF_STATEMENT)) {
                tokens.consume();
                Returnable<?> elseCondition = this.parseExpression(tokens, true, variableMap);
                ParserUtil.checkReturnType(elseCondition, Returnable.ReturnType.BOOLEAN);
                elseIf.add(new IfKeyword.Pair(elseCondition, this.parseStatementBlock(tokens, variableMap, loop)));
                continue;
            }
            elseBlock = this.parseStatementBlock(tokens, variableMap, loop);
            break;
        }
        return new IfKeyword(statement, condition, elseIf, elseBlock, start);
    }

    private Block parseStatementBlock(Tokenizer tokens, Map<String, Returnable.ReturnType> variableMap, boolean loop) throws ParseException {
        if (tokens.get().getType().equals((Object)Token.Type.BLOCK_BEGIN)) {
            ParserUtil.checkType(tokens.consume(), Token.Type.BLOCK_BEGIN);
            Block block = this.parseBlock(tokens, variableMap, loop);
            ParserUtil.checkType(tokens.consume(), Token.Type.BLOCK_END);
            return block;
        }
        Position position = tokens.get().getPosition();
        Block block = new Block(Collections.singletonList(this.parseItem(tokens, variableMap, loop)), position);
        ParserUtil.checkType(tokens.consume(), Token.Type.STATEMENT_END);
        return block;
    }

    private ForKeyword parseForLoop(Tokenizer tokens, Map<String, Returnable.ReturnType> old, Position start) throws ParseException {
        Item<?> initializer;
        HashMap<String, Returnable.ReturnType> variableMap = new HashMap<String, Returnable.ReturnType>(old);
        Token f = tokens.get();
        ParserUtil.checkType(f, Token.Type.NUMBER_VARIABLE, Token.Type.STRING_VARIABLE, Token.Type.BOOLEAN_VARIABLE, Token.Type.IDENTIFIER);
        if (f.isVariableDeclaration()) {
            Declaration<?> forVar = this.parseVariableDeclaration(tokens, variableMap);
            Token name = tokens.get();
            if (this.functions.containsKey(name.getContent()) || variableMap.containsKey(name.getContent())) {
                throw new ParseException(name.getContent() + " is already defined in this scope", name.getPosition());
            }
            initializer = forVar;
        } else {
            initializer = this.parseExpression(tokens, true, variableMap);
        }
        ParserUtil.checkType(tokens.consume(), Token.Type.STATEMENT_END);
        Returnable<Boolean> conditional = this.parseExpression(tokens, true, variableMap);
        ParserUtil.checkReturnType(conditional, Returnable.ReturnType.BOOLEAN);
        ParserUtil.checkType(tokens.consume(), Token.Type.STATEMENT_END);
        Token token = tokens.get();
        Item<?> incrementer = variableMap.containsKey(token.getContent()) ? this.parseAssignment(tokens, variableMap) : this.parseFunction(tokens, true, variableMap);
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_END);
        return new ForKeyword(this.parseStatementBlock(tokens, variableMap, true), initializer, conditional, incrementer, start);
    }

    private Returnable<?> parseExpression(Tokenizer tokens, boolean full, Map<String, Returnable.ReturnType> variableMap) throws ParseException {
        Returnable<Boolean> expression;
        boolean booleanInverted = false;
        boolean negate = false;
        if (tokens.get().getType().equals((Object)Token.Type.BOOLEAN_NOT)) {
            booleanInverted = true;
            tokens.consume();
        } else if (tokens.get().getType().equals((Object)Token.Type.SUBTRACTION_OPERATOR)) {
            negate = true;
            tokens.consume();
        }
        Token id = tokens.get();
        ParserUtil.checkType(id, Token.Type.IDENTIFIER, Token.Type.BOOLEAN, Token.Type.STRING, Token.Type.NUMBER, Token.Type.GROUP_BEGIN);
        if (id.isConstant()) {
            expression = this.parseConstantExpression(tokens);
        } else if (id.getType().equals((Object)Token.Type.GROUP_BEGIN)) {
            expression = this.parseGroup(tokens, variableMap);
        } else if (this.functions.containsKey(id.getContent())) {
            expression = this.parseFunction(tokens, false, variableMap);
        } else if (variableMap.containsKey(id.getContent())) {
            ParserUtil.checkType(tokens.consume(), Token.Type.IDENTIFIER);
            expression = new Getter(id.getContent(), id.getPosition(), variableMap.get(id.getContent()));
        } else {
            throw new ParseException("Unexpected token \" " + id.getContent() + "\"", id.getPosition());
        }
        if (booleanInverted) {
            ParserUtil.checkReturnType(expression, Returnable.ReturnType.BOOLEAN);
            expression = new BooleanNotOperation(expression, expression.getPosition());
        } else if (negate) {
            ParserUtil.checkReturnType(expression, Returnable.ReturnType.NUMBER);
            expression = new NegationOperation((Returnable<Number>)expression, expression.getPosition());
        }
        if (full && tokens.get().isBinaryOperator()) {
            return this.parseBinaryOperation(expression, tokens, variableMap);
        }
        return expression;
    }

    private ConstantExpression<?> parseConstantExpression(Tokenizer tokens) throws ParseException {
        Token constantToken = tokens.consume();
        Position position = constantToken.getPosition();
        switch (constantToken.getType()) {
            case NUMBER: {
                String content = constantToken.getContent();
                return new NumericConstant(content.contains(".") ? Double.parseDouble(content) : (double)Integer.parseInt(content), position);
            }
            case STRING: {
                return new StringConstant(constantToken.getContent(), position);
            }
            case BOOLEAN: {
                return new BooleanConstant(Boolean.parseBoolean(constantToken.getContent()), position);
            }
        }
        throw new UnsupportedOperationException("Unsupported constant token: " + (Object)((Object)constantToken.getType()) + " at position: " + position);
    }

    private Returnable<?> parseGroup(Tokenizer tokens, Map<String, Returnable.ReturnType> variableMap) throws ParseException {
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_BEGIN);
        Returnable<?> expression = this.parseExpression(tokens, true, variableMap);
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_END);
        return expression;
    }

    private BinaryOperation<?, ?> parseBinaryOperation(Returnable<?> left, Tokenizer tokens, Map<String, Returnable.ReturnType> variableMap) throws ParseException {
        Token binaryOperator = tokens.consume();
        ParserUtil.checkBinaryOperator(binaryOperator);
        Returnable<?> right = this.parseExpression(tokens, false, variableMap);
        Token other = tokens.get();
        if (ParserUtil.hasPrecedence(binaryOperator.getType(), other.getType())) {
            return this.assemble(left, this.parseBinaryOperation(right, tokens, variableMap), binaryOperator);
        }
        if (other.isBinaryOperator()) {
            return this.parseBinaryOperation(this.assemble(left, right, binaryOperator), tokens, variableMap);
        }
        return this.assemble(left, right, binaryOperator);
    }

    private BinaryOperation<?, ?> assemble(Returnable<?> left, Returnable<?> right, Token binaryOperator) throws ParseException {
        if (binaryOperator.isStrictNumericOperator()) {
            ParserUtil.checkArithmeticOperation(left, right, binaryOperator);
        }
        if (binaryOperator.isStrictBooleanOperator()) {
            ParserUtil.checkBooleanOperation(left, right, binaryOperator);
        }
        switch (binaryOperator.getType()) {
            case ADDITION_OPERATOR: {
                if (left.returnType().equals((Object)Returnable.ReturnType.NUMBER) && right.returnType().equals((Object)Returnable.ReturnType.NUMBER)) {
                    return new NumberAdditionOperation((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
                }
                return new ConcatenationOperation(left, right, binaryOperator.getPosition());
            }
            case SUBTRACTION_OPERATOR: {
                return new SubtractionOperation((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
            case MULTIPLICATION_OPERATOR: {
                return new MultiplicationOperation((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
            case DIVISION_OPERATOR: {
                return new DivisionOperation((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
            case EQUALS_OPERATOR: {
                return new EqualsStatement(left, right, binaryOperator.getPosition());
            }
            case NOT_EQUALS_OPERATOR: {
                return new NotEqualsStatement(left, right, binaryOperator.getPosition());
            }
            case GREATER_THAN_OPERATOR: {
                return new GreaterThanStatement((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
            case LESS_THAN_OPERATOR: {
                return new LessThanStatement((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
            case GREATER_THAN_OR_EQUALS_OPERATOR: {
                return new GreaterOrEqualsThanStatement((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
            case LESS_THAN_OR_EQUALS_OPERATOR: {
                return new LessThanOrEqualsStatement((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
            case BOOLEAN_AND: {
                return new BooleanAndOperation((Returnable<Boolean>)left, (Returnable<Boolean>)right, binaryOperator.getPosition());
            }
            case BOOLEAN_OR: {
                return new BooleanOrOperation((Returnable<Boolean>)left, (Returnable<Boolean>)right, binaryOperator.getPosition());
            }
            case MODULO_OPERATOR: {
                return new ModuloOperation((Returnable<Number>)left, (Returnable<Number>)right, binaryOperator.getPosition());
            }
        }
        throw new UnsupportedOperationException("Unsupported binary operator: " + (Object)((Object)binaryOperator.getType()));
    }

    private Declaration<?> parseVariableDeclaration(Tokenizer tokens, Map<String, Returnable.ReturnType> variableMap) throws ParseException {
        Token type = tokens.consume();
        ParserUtil.checkType(type, Token.Type.STRING_VARIABLE, Token.Type.BOOLEAN_VARIABLE, Token.Type.NUMBER_VARIABLE);
        Returnable.ReturnType returnType = ParserUtil.getVariableReturnType(type);
        ParserUtil.checkVarType(type, returnType);
        Token identifier = tokens.consume();
        ParserUtil.checkType(identifier, Token.Type.IDENTIFIER);
        if (this.functions.containsKey(identifier.getContent()) || variableMap.containsKey(identifier.getContent())) {
            throw new ParseException(identifier.getContent() + " is already defined in this scope", identifier.getPosition());
        }
        ParserUtil.checkType(tokens.consume(), Token.Type.ASSIGNMENT);
        Returnable<?> value = this.parseExpression(tokens, true, variableMap);
        ParserUtil.checkReturnType(value, returnType);
        variableMap.put(identifier.getContent(), returnType);
        return new Declaration(tokens.get().getPosition(), identifier.getContent(), value, returnType);
    }

    private Block parseBlock(Tokenizer tokens, Map<String, Returnable.ReturnType> superVars, boolean loop) throws ParseException {
        Token token;
        GlueList parsedItems = new GlueList();
        HashMap<String, Returnable.ReturnType> parsedVariables = new HashMap<String, Returnable.ReturnType>(superVars);
        Token first = tokens.get();
        while (tokens.hasNext() && !(token = tokens.get()).getType().equals((Object)Token.Type.BLOCK_END)) {
            parsedItems.add(this.parseItem(tokens, parsedVariables, loop));
            if (!tokens.hasNext() || token.isLoopLike()) continue;
            ParserUtil.checkType(tokens.consume(), Token.Type.STATEMENT_END);
        }
        return new Block(parsedItems, first.getPosition());
    }

    private Item<?> parseItem(Tokenizer tokens, Map<String, Returnable.ReturnType> variableMap, boolean loop) throws ParseException {
        Token token = tokens.get();
        if (loop) {
            ParserUtil.checkType(token, Token.Type.IDENTIFIER, Token.Type.IF_STATEMENT, Token.Type.WHILE_LOOP, Token.Type.FOR_LOOP, Token.Type.NUMBER_VARIABLE, Token.Type.STRING_VARIABLE, Token.Type.BOOLEAN_VARIABLE, Token.Type.RETURN, Token.Type.BREAK, Token.Type.CONTINUE, Token.Type.FAIL);
        } else {
            ParserUtil.checkType(token, Token.Type.IDENTIFIER, Token.Type.IF_STATEMENT, Token.Type.WHILE_LOOP, Token.Type.FOR_LOOP, Token.Type.NUMBER_VARIABLE, Token.Type.STRING_VARIABLE, Token.Type.BOOLEAN_VARIABLE, Token.Type.RETURN, Token.Type.FAIL);
        }
        if (token.isLoopLike()) {
            return this.parseLoopLike(tokens, variableMap, loop);
        }
        if (token.isIdentifier()) {
            if (variableMap.containsKey(token.getContent())) {
                return this.parseAssignment(tokens, variableMap);
            }
            return this.parseFunction(tokens, true, variableMap);
        }
        if (token.isVariableDeclaration()) {
            return this.parseVariableDeclaration(tokens, variableMap);
        }
        if (token.getType().equals((Object)Token.Type.RETURN)) {
            return new ReturnKeyword(tokens.consume().getPosition());
        }
        if (token.getType().equals((Object)Token.Type.BREAK)) {
            return new BreakKeyword(tokens.consume().getPosition());
        }
        if (token.getType().equals((Object)Token.Type.CONTINUE)) {
            return new ContinueKeyword(tokens.consume().getPosition());
        }
        if (token.getType().equals((Object)Token.Type.FAIL)) {
            return new FailKeyword(tokens.consume().getPosition());
        }
        throw new UnsupportedOperationException("Unexpected token " + (Object)((Object)token.getType()) + ": " + token.getPosition());
    }

    private Assignment<?> parseAssignment(Tokenizer tokens, Map<String, Returnable.ReturnType> variableMap) throws ParseException {
        Token identifier = tokens.consume();
        ParserUtil.checkType(identifier, Token.Type.IDENTIFIER);
        ParserUtil.checkType(tokens.consume(), Token.Type.ASSIGNMENT);
        Returnable<?> value = this.parseExpression(tokens, true, variableMap);
        ParserUtil.checkReturnType(value, variableMap.get(identifier.getContent()));
        return new Assignment(value, identifier.getContent(), identifier.getPosition());
    }

    private Function<?> parseFunction(Tokenizer tokens, boolean fullStatement, Map<String, Returnable.ReturnType> variableMap) throws ParseException {
        Token identifier = tokens.consume();
        ParserUtil.checkType(identifier, Token.Type.IDENTIFIER);
        if (!this.functions.containsKey(identifier.getContent())) {
            throw new ParseException("No such function \"" + identifier.getContent() + "\"", identifier.getPosition());
        }
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_BEGIN);
        List<Returnable<?>> args = this.getArgs(tokens, variableMap);
        ParserUtil.checkType(tokens.consume(), Token.Type.GROUP_END);
        if (fullStatement) {
            ParserUtil.checkType(tokens.get(), Token.Type.STATEMENT_END);
        }
        if (this.functions.containsKey(identifier.getContent())) {
            FunctionBuilder<Function<?>> builder = this.functions.get(identifier.getContent());
            if (builder.argNumber() != -1 && args.size() != builder.argNumber()) {
                throw new ParseException("Expected " + builder.argNumber() + " arguments, found " + args.size(), identifier.getPosition());
            }
            for (int i = 0; i < args.size(); ++i) {
                Returnable<?> argument = args.get(i);
                if (builder.getArgument(i) == null) {
                    throw new ParseException("Unexpected argument at position " + i + " in function " + identifier.getContent(), identifier.getPosition());
                }
                ParserUtil.checkReturnType(argument, builder.getArgument(i));
            }
            return builder.build(args, identifier.getPosition());
        }
        throw new UnsupportedOperationException("Unsupported function: " + identifier.getContent());
    }

    private List<Returnable<?>> getArgs(Tokenizer tokens, Map<String, Returnable.ReturnType> variableMap) throws ParseException {
        GlueList args = new GlueList();
        while (!tokens.get().getType().equals((Object)Token.Type.GROUP_END)) {
            args.add(this.parseExpression(tokens, true, variableMap));
            ParserUtil.checkType(tokens.get(), Token.Type.SEPARATOR, Token.Type.GROUP_END);
            if (!tokens.get().getType().equals((Object)Token.Type.SEPARATOR)) continue;
            tokens.consume();
        }
        return args;
    }
}

