/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.parser;

import com.dfsek.terra.api.structures.parser.exceptions.ParseException;
import com.dfsek.terra.api.structures.parser.lang.Returnable;
import com.dfsek.terra.api.structures.tokenizer.Token;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParserUtil {
    private static final Map<Token.Type, Map<Token.Type, Boolean>> PRECEDENCE = new HashMap<Token.Type, Map<Token.Type, Boolean>>();
    private static final List<Token.Type> ARITHMETIC = Arrays.asList(Token.Type.ADDITION_OPERATOR, Token.Type.SUBTRACTION_OPERATOR, Token.Type.MULTIPLICATION_OPERATOR, Token.Type.DIVISION_OPERATOR, Token.Type.MODULO_OPERATOR);
    private static final List<Token.Type> COMPARISON = Arrays.asList(Token.Type.EQUALS_OPERATOR, Token.Type.NOT_EQUALS_OPERATOR, Token.Type.LESS_THAN_OPERATOR, Token.Type.LESS_THAN_OR_EQUALS_OPERATOR, Token.Type.GREATER_THAN_OPERATOR, Token.Type.GREATER_THAN_OR_EQUALS_OPERATOR);

    public static void checkType(Token token, Token.Type ... expected) throws ParseException {
        for (Token.Type type : expected) {
            if (!token.getType().equals((Object)type)) continue;
            return;
        }
        throw new ParseException("Expected " + Arrays.toString((Object[])expected) + " but found " + (Object)((Object)token.getType()), token.getPosition());
    }

    public static void checkReturnType(Returnable<?> returnable, Returnable.ReturnType ... types) throws ParseException {
        for (Returnable.ReturnType type : types) {
            if (!returnable.returnType().equals((Object)type)) continue;
            return;
        }
        throw new ParseException("Expected " + Arrays.toString((Object[])types) + " but found " + (Object)((Object)returnable.returnType()), returnable.getPosition());
    }

    public static void checkArithmeticOperation(Returnable<?> left, Returnable<?> right, Token operation) throws ParseException {
        if (!left.returnType().equals((Object)Returnable.ReturnType.NUMBER) || !right.returnType().equals((Object)Returnable.ReturnType.NUMBER)) {
            throw new ParseException("Operation " + (Object)((Object)operation.getType()) + " not supported between " + (Object)((Object)left.returnType()) + " and " + (Object)((Object)right.returnType()), operation.getPosition());
        }
    }

    public static void checkBooleanOperation(Returnable<?> left, Returnable<?> right, Token operation) throws ParseException {
        if (!left.returnType().equals((Object)Returnable.ReturnType.BOOLEAN) || !right.returnType().equals((Object)Returnable.ReturnType.BOOLEAN)) {
            throw new ParseException("Operation " + (Object)((Object)operation.getType()) + " not supported between " + (Object)((Object)left.returnType()) + " and " + (Object)((Object)right.returnType()), operation.getPosition());
        }
    }

    public static void checkVarType(Token token, Returnable.ReturnType returnType) throws ParseException {
        if (returnType.equals((Object)Returnable.ReturnType.STRING) && token.getType().equals((Object)Token.Type.STRING_VARIABLE)) {
            return;
        }
        if (returnType.equals((Object)Returnable.ReturnType.NUMBER) && token.getType().equals((Object)Token.Type.NUMBER_VARIABLE)) {
            return;
        }
        if (returnType.equals((Object)Returnable.ReturnType.BOOLEAN) && token.getType().equals((Object)Token.Type.BOOLEAN_VARIABLE)) {
            return;
        }
        throw new ParseException("Type mismatch, cannot convert from " + (Object)((Object)returnType) + " to " + (Object)((Object)token.getType()), token.getPosition());
    }

    public static void checkBinaryOperator(Token token) throws ParseException {
        if (!token.isBinaryOperator()) {
            throw new ParseException("Expected binary operator, found " + (Object)((Object)token.getType()), token.getPosition());
        }
    }

    public static Returnable.ReturnType getVariableReturnType(Token varToken) throws ParseException {
        switch (varToken.getType()) {
            case NUMBER_VARIABLE: {
                return Returnable.ReturnType.NUMBER;
            }
            case STRING_VARIABLE: {
                return Returnable.ReturnType.STRING;
            }
            case BOOLEAN_VARIABLE: {
                return Returnable.ReturnType.BOOLEAN;
            }
        }
        throw new ParseException("Unexpected token " + (Object)((Object)varToken.getType()) + "; expected variable declaration", varToken.getPosition());
    }

    public static boolean hasPrecedence(Token.Type first, Token.Type second) {
        if (!PRECEDENCE.containsKey((Object)first)) {
            return false;
        }
        Map<Token.Type, Boolean> pre = PRECEDENCE.get((Object)first);
        if (!pre.containsKey((Object)second)) {
            return false;
        }
        return pre.get((Object)second);
    }

    static {
        HashMap<Token.Type, Boolean> add = new HashMap<Token.Type, Boolean>();
        add.put(Token.Type.MULTIPLICATION_OPERATOR, true);
        add.put(Token.Type.DIVISION_OPERATOR, true);
        PRECEDENCE.put(Token.Type.ADDITION_OPERATOR, add);
        PRECEDENCE.put(Token.Type.SUBTRACTION_OPERATOR, add);
        HashMap numericBoolean = new HashMap();
        ARITHMETIC.forEach(op -> numericBoolean.put(op, true));
        COMPARISON.forEach(op -> PRECEDENCE.put((Token.Type)((Object)op), numericBoolean));
        HashMap booleanOps = new HashMap();
        ARITHMETIC.forEach(op -> booleanOps.put(op, true));
        COMPARISON.forEach(op -> booleanOps.put(op, true));
        PRECEDENCE.put(Token.Type.BOOLEAN_AND, booleanOps);
        PRECEDENCE.put(Token.Type.BOOLEAN_OR, booleanOps);
    }
}

