/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.parser.lang.keywords.looplike;

import com.dfsek.terra.api.structures.parser.lang.Block;
import com.dfsek.terra.api.structures.parser.lang.ImplementationArguments;
import com.dfsek.terra.api.structures.parser.lang.Keyword;
import com.dfsek.terra.api.structures.parser.lang.Returnable;
import com.dfsek.terra.api.structures.parser.lang.variables.Variable;
import com.dfsek.terra.api.structures.tokenizer.Position;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class IfKeyword
implements Keyword<Block.ReturnInfo<?>> {
    private final Block conditional;
    private final Returnable<Boolean> statement;
    private final Position position;
    private final List<Pair<Returnable<Boolean>, Block>> elseIf;
    private final Block elseBlock;

    public IfKeyword(Block conditional, Returnable<Boolean> statement, List<Pair<Returnable<Boolean>, Block>> elseIf, @Nullable Block elseBlock, Position position) {
        this.conditional = conditional;
        this.statement = statement;
        this.position = position;
        this.elseIf = elseIf;
        this.elseBlock = elseBlock;
    }

    @Override
    public Block.ReturnInfo<?> apply(ImplementationArguments implementationArguments, Map<String, Variable<?>> variableMap) {
        if (((Boolean)this.statement.apply(implementationArguments, variableMap)).booleanValue()) {
            return this.conditional.apply(implementationArguments, (Map)variableMap);
        }
        for (Pair<Returnable<Boolean>, Block> pair : this.elseIf) {
            if (!((Boolean)pair.getLeft().apply(implementationArguments, variableMap)).booleanValue()) continue;
            return pair.getRight().apply(implementationArguments, (Map)variableMap);
        }
        if (this.elseBlock != null) {
            return this.elseBlock.apply(implementationArguments, (Map)variableMap);
        }
        return new Block.ReturnInfo<Object>(Block.ReturnLevel.NONE, null);
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public Returnable.ReturnType returnType() {
        return Returnable.ReturnType.VOID;
    }

    public static class Pair<L, R> {
        private final L left;
        private final R right;

        public Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }

        public L getLeft() {
            return this.left;
        }

        public R getRight() {
            return this.right;
        }
    }
}

