/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.parser.lang.operations.statements;

import com.dfsek.terra.api.structures.parser.lang.Returnable;
import com.dfsek.terra.api.structures.parser.lang.operations.BinaryOperation;
import com.dfsek.terra.api.structures.tokenizer.Position;
import com.dfsek.terra.lib.jafama.FastMath;

public class EqualsStatement
extends BinaryOperation<Object, Boolean> {
    private static final double EPSILON = 1.0E-9;

    public EqualsStatement(Returnable<Object> left, Returnable<Object> right, Position position) {
        super(left, right, position);
    }

    @Override
    public Boolean apply(Object left, Object right) {
        if (left instanceof Number && right instanceof Number) {
            return FastMath.abs(((Number)left).doubleValue() - ((Number)right).doubleValue()) <= 1.0E-9;
        }
        return left.equals(right);
    }

    @Override
    public Returnable.ReturnType returnType() {
        return Returnable.ReturnType.BOOLEAN;
    }
}

