/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.parser.lang.variables;

import com.dfsek.terra.api.structures.parser.lang.ImplementationArguments;
import com.dfsek.terra.api.structures.parser.lang.Item;
import com.dfsek.terra.api.structures.parser.lang.Returnable;
import com.dfsek.terra.api.structures.parser.lang.variables.BooleanVariable;
import com.dfsek.terra.api.structures.parser.lang.variables.NumberVariable;
import com.dfsek.terra.api.structures.parser.lang.variables.StringVariable;
import com.dfsek.terra.api.structures.parser.lang.variables.Variable;
import com.dfsek.terra.api.structures.tokenizer.Position;
import java.util.Map;

public class Declaration<T>
implements Item<T> {
    private final Position position;
    private final String identifier;
    private final Returnable<T> value;
    private final Returnable.ReturnType type;

    public Declaration(Position position, String identifier, Returnable<T> value, Returnable.ReturnType type) {
        switch (type) {
            case STRING: 
            case BOOLEAN: 
            case NUMBER: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid variable type: " + (Object)((Object)type));
            }
        }
        this.position = position;
        this.identifier = identifier;
        this.value = value;
        this.type = type;
    }

    @Override
    public T apply(ImplementationArguments implementationArguments, Map<String, Variable<?>> variableMap) {
        Object result = this.value.apply(implementationArguments, variableMap);
        switch (this.type) {
            case NUMBER: {
                variableMap.put(this.identifier, new NumberVariable((Number)result, this.position));
                break;
            }
            case BOOLEAN: {
                variableMap.put(this.identifier, new BooleanVariable((Boolean)result, this.position));
                break;
            }
            case STRING: {
                variableMap.put(this.identifier, new StringVariable((String)result, this.position));
            }
        }
        return result;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    public Returnable.ReturnType getType() {
        return this.type;
    }

    public String getIdentifier() {
        return this.identifier;
    }
}

