/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.script.builders;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.structures.parser.exceptions.ParseException;
import com.dfsek.terra.api.structures.parser.lang.Returnable;
import com.dfsek.terra.api.structures.parser.lang.constants.BooleanConstant;
import com.dfsek.terra.api.structures.parser.lang.functions.FunctionBuilder;
import com.dfsek.terra.api.structures.script.functions.AbstractBlockFunction;
import com.dfsek.terra.api.structures.script.functions.BlockFunction;
import com.dfsek.terra.api.structures.script.functions.DynamicBlockFunction;
import com.dfsek.terra.api.structures.tokenizer.Position;
import java.util.List;

public class BlockFunctionBuilder
implements FunctionBuilder<AbstractBlockFunction> {
    private final TerraPlugin main;
    private final boolean dynamic;

    public BlockFunctionBuilder(TerraPlugin main, boolean dynamic) {
        this.main = main;
        this.dynamic = dynamic;
    }

    @Override
    public AbstractBlockFunction build(List<Returnable<?>> argumentList, Position position) throws ParseException {
        if (argumentList.size() < 4) {
            throw new ParseException("Expected data", position);
        }
        Returnable<Boolean> booleanReturnable = new BooleanConstant(true, position);
        if (argumentList.size() == 5) {
            booleanReturnable = argumentList.get(4);
        }
        if (this.dynamic) {
            return new DynamicBlockFunction(argumentList.get(0), argumentList.get(1), argumentList.get(2), argumentList.get(3), booleanReturnable, this.main, position);
        }
        return new BlockFunction(argumentList.get(0), argumentList.get(1), argumentList.get(2), argumentList.get(3), booleanReturnable, this.main, position);
    }

    @Override
    public int argNumber() {
        return -1;
    }

    @Override
    public Returnable.ReturnType getArgument(int position) {
        switch (position) {
            case 0: 
            case 1: 
            case 2: {
                return Returnable.ReturnType.NUMBER;
            }
            case 3: {
                return Returnable.ReturnType.STRING;
            }
            case 4: {
                return Returnable.ReturnType.BOOLEAN;
            }
        }
        return null;
    }
}

