/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.script.functions;

import com.dfsek.terra.api.math.vector.Vector2;
import com.dfsek.terra.api.math.vector.Vector3;
import com.dfsek.terra.api.structures.parser.lang.ImplementationArguments;
import com.dfsek.terra.api.structures.parser.lang.Returnable;
import com.dfsek.terra.api.structures.parser.lang.functions.Function;
import com.dfsek.terra.api.structures.parser.lang.variables.Variable;
import com.dfsek.terra.api.structures.script.TerraImplementationArguments;
import com.dfsek.terra.api.structures.structure.RotationUtil;
import com.dfsek.terra.api.structures.tokenizer.Position;
import com.dfsek.terra.lib.jafama.FastMath;
import java.util.Map;

public class CheckBlockFunction
implements Function<String> {
    private final Returnable<Number> x;
    private final Returnable<Number> y;
    private final Returnable<Number> z;
    private final Position position;

    public CheckBlockFunction(Returnable<Number> x, Returnable<Number> y, Returnable<Number> z, Position position) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.position = position;
    }

    @Override
    public String apply(ImplementationArguments implementationArguments, Map<String, Variable<?>> variableMap) {
        TerraImplementationArguments arguments = (TerraImplementationArguments)implementationArguments;
        Vector2 xz = new Vector2(((Number)this.x.apply(implementationArguments, variableMap)).doubleValue(), ((Number)this.z.apply(implementationArguments, variableMap)).doubleValue());
        RotationUtil.rotateVector(xz, arguments.getRotation());
        String data = arguments.getBuffer().getOrigin().clone().add(new Vector3(FastMath.roundToInt(xz.getX()), ((Number)this.y.apply(implementationArguments, variableMap)).doubleValue(), FastMath.roundToInt(xz.getZ()))).getBlock().getBlockData().getAsString();
        if (data.contains("[")) {
            return data.substring(0, data.indexOf(91));
        }
        return data;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public Returnable.ReturnType returnType() {
        return Returnable.ReturnType.STRING;
    }
}

