/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.script.functions;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.math.vector.Location;
import com.dfsek.terra.api.math.vector.Vector2;
import com.dfsek.terra.api.math.vector.Vector3;
import com.dfsek.terra.api.platform.world.World;
import com.dfsek.terra.api.structures.parser.lang.ImplementationArguments;
import com.dfsek.terra.api.structures.parser.lang.Returnable;
import com.dfsek.terra.api.structures.parser.lang.functions.Function;
import com.dfsek.terra.api.structures.parser.lang.variables.Variable;
import com.dfsek.terra.api.structures.script.TerraImplementationArguments;
import com.dfsek.terra.api.structures.structure.RotationUtil;
import com.dfsek.terra.api.structures.tokenizer.Position;
import com.dfsek.terra.api.world.biome.UserDefinedBiome;
import com.dfsek.terra.api.world.biome.provider.BiomeProvider;
import com.dfsek.terra.config.templates.BiomeTemplate;
import com.dfsek.terra.lib.jafama.FastMath;
import com.dfsek.terra.world.TerraWorld;
import com.dfsek.terra.world.generation.math.SamplerCache;
import java.util.Map;

public class CheckFunction
implements Function<String> {
    private final TerraPlugin main;
    private final Returnable<Number> x;
    private final Returnable<Number> y;
    private final Returnable<Number> z;
    private final Position position;

    public CheckFunction(TerraPlugin main, Returnable<Number> x, Returnable<Number> y, Returnable<Number> z, Position position) {
        this.main = main;
        this.x = x;
        this.y = y;
        this.z = z;
        this.position = position;
    }

    @Override
    public String apply(ImplementationArguments implementationArguments, Map<String, Variable<?>> variableMap) {
        TerraImplementationArguments arguments = (TerraImplementationArguments)implementationArguments;
        Vector2 xz = new Vector2(((Number)this.x.apply(implementationArguments, variableMap)).doubleValue(), ((Number)this.z.apply(implementationArguments, variableMap)).doubleValue());
        RotationUtil.rotateVector(xz, arguments.getRotation());
        Location location = arguments.getBuffer().getOrigin().clone().add(new Vector3(FastMath.roundToInt(xz.getX()), ((Number)this.y.apply(implementationArguments, variableMap)).doubleValue(), FastMath.roundToInt(xz.getZ())));
        return this.apply(location, arguments.getBuffer().getOrigin().getWorld());
    }

    private String apply(Location vector, World world) {
        TerraWorld tw = this.main.getWorld(world);
        SamplerCache cache = tw.getConfig().getSamplerCache();
        double comp = this.sample(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ(), cache);
        if (comp > 0.0) {
            return "LAND";
        }
        BiomeProvider provider = tw.getBiomeProvider();
        UserDefinedBiome b = (UserDefinedBiome)provider.getBiome(vector.getBlockX(), vector.getBlockZ());
        BiomeTemplate c = b.getConfig();
        if (vector.getY() > (double)c.getSeaLevel()) {
            return "AIR";
        }
        return "OCEAN";
    }

    private double sample(int x, int y, int z, SamplerCache cache) {
        int cx = FastMath.floorDiv(x, 16);
        int cz = FastMath.floorDiv(z, 16);
        return cache.get(x, z).sample(x - (cx << 4), y, z - (cz << 4));
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public Returnable.ReturnType returnType() {
        return Returnable.ReturnType.STRING;
    }
}

