/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.script.functions;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.math.vector.Vector2;
import com.dfsek.terra.api.math.vector.Vector3;
import com.dfsek.terra.api.structures.loot.LootTable;
import com.dfsek.terra.api.structures.parser.lang.ImplementationArguments;
import com.dfsek.terra.api.structures.parser.lang.Returnable;
import com.dfsek.terra.api.structures.parser.lang.functions.Function;
import com.dfsek.terra.api.structures.parser.lang.variables.Variable;
import com.dfsek.terra.api.structures.script.StructureScript;
import com.dfsek.terra.api.structures.script.TerraImplementationArguments;
import com.dfsek.terra.api.structures.structure.RotationUtil;
import com.dfsek.terra.api.structures.structure.buffer.items.BufferedLootApplication;
import com.dfsek.terra.api.structures.tokenizer.Position;
import com.dfsek.terra.lib.jafama.FastMath;
import com.dfsek.terra.registry.config.LootRegistry;
import java.util.Map;

public class LootFunction
implements Function<Void> {
    private final LootRegistry registry;
    private final Returnable<String> data;
    private final Returnable<Number> x;
    private final Returnable<Number> y;
    private final Returnable<Number> z;
    private final Position position;
    private final TerraPlugin main;
    private final StructureScript script;

    public LootFunction(LootRegistry registry, Returnable<Number> x, Returnable<Number> y, Returnable<Number> z, Returnable<String> data, TerraPlugin main, Position position, StructureScript script) {
        this.registry = registry;
        this.position = position;
        this.data = data;
        this.x = x;
        this.y = y;
        this.z = z;
        this.main = main;
        this.script = script;
    }

    @Override
    public Void apply(ImplementationArguments implementationArguments, Map<String, Variable<?>> variableMap) {
        TerraImplementationArguments arguments = (TerraImplementationArguments)implementationArguments;
        Vector2 xz = new Vector2(((Number)this.x.apply(implementationArguments, variableMap)).doubleValue(), ((Number)this.z.apply(implementationArguments, variableMap)).doubleValue());
        RotationUtil.rotateVector(xz, arguments.getRotation());
        String id = (String)this.data.apply(implementationArguments, variableMap);
        LootTable table = (LootTable)this.registry.get(id);
        if (table == null) {
            this.main.logger().severe("No such loot table " + id);
            return null;
        }
        arguments.getBuffer().addItem(new BufferedLootApplication(table, this.main, this.script), new Vector3(FastMath.roundToInt(xz.getX()), ((Number)this.y.apply(implementationArguments, variableMap)).intValue(), FastMath.roundToInt(xz.getZ())).toLocation(arguments.getBuffer().getOrigin().getWorld()));
        return null;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public Returnable.ReturnType returnType() {
        return Returnable.ReturnType.VOID;
    }
}

