/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.structure;

import com.dfsek.terra.lib.jafama.FastMath;

public enum Rotation {
    CW_90(90),
    CW_180(180),
    CCW_90(270),
    NONE(0);

    private final int degrees;

    private Rotation(int degrees) {
        this.degrees = degrees;
    }

    public static Rotation fromDegrees(int deg) {
        switch (FastMath.floorMod(deg, 360)) {
            case 0: {
                return NONE;
            }
            case 90: {
                return CW_90;
            }
            case 180: {
                return CW_180;
            }
            case 270: {
                return CCW_90;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getDegrees() {
        return this.degrees;
    }

    public Rotation inverse() {
        switch (this) {
            case NONE: {
                return NONE;
            }
            case CCW_90: {
                return CW_90;
            }
            case CW_90: {
                return CCW_90;
            }
            case CW_180: {
                return CW_180;
            }
        }
        throw new IllegalArgumentException();
    }

    public Rotation rotate(Rotation rotation) {
        return Rotation.fromDegrees(this.getDegrees() + rotation.getDegrees());
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }
}

