/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.structure;

import com.dfsek.terra.api.math.vector.Vector2;
import com.dfsek.terra.api.platform.block.Axis;
import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.platform.block.BlockFace;
import com.dfsek.terra.api.platform.block.data.Directional;
import com.dfsek.terra.api.platform.block.data.MultipleFacing;
import com.dfsek.terra.api.platform.block.data.Orientable;
import com.dfsek.terra.api.platform.block.data.Rail;
import com.dfsek.terra.api.platform.block.data.RedstoneWire;
import com.dfsek.terra.api.platform.block.data.Rotatable;
import com.dfsek.terra.api.platform.block.data.Wall;
import com.dfsek.terra.api.structures.structure.Rotation;
import com.dfsek.terra.lib.jafama.FastMath;
import com.google.common.collect.Sets;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;

public class RotationUtil {
    private static final Set<BlockFace> CARDINALS = Sets.newHashSet((Object[])new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST});

    public static void rotateVector(Vector2 orig, Rotation r) {
        Vector2 copy = orig.clone();
        switch (r) {
            case CW_90: {
                copy.setX(orig.getZ()).setZ(-orig.getX());
                break;
            }
            case CCW_90: {
                copy.setX(-orig.getZ()).setZ(orig.getX());
                break;
            }
            case CW_180: {
                copy.multiply(-1.0);
            }
        }
        orig.setX(copy.getX());
        orig.setZ(copy.getZ());
    }

    public static BlockFace getRotatedFace(BlockFace f, Rotation r) {
        BlockFace n = f;
        int rotateNum = r.getDegrees() / 90;
        int rn = RotationUtil.faceRotation(f);
        if (rn >= 0) {
            n = RotationUtil.fromRotation(RotationUtil.faceRotation(n) + 4 * rotateNum);
        }
        return n;
    }

    public static int faceRotation(BlockFace f) {
        switch (f) {
            case NORTH: {
                return 0;
            }
            case NORTH_NORTH_EAST: {
                return 1;
            }
            case NORTH_EAST: {
                return 2;
            }
            case EAST_NORTH_EAST: {
                return 3;
            }
            case EAST: {
                return 4;
            }
            case EAST_SOUTH_EAST: {
                return 5;
            }
            case SOUTH_EAST: {
                return 6;
            }
            case SOUTH_SOUTH_EAST: {
                return 7;
            }
            case SOUTH: {
                return 8;
            }
            case SOUTH_SOUTH_WEST: {
                return 9;
            }
            case SOUTH_WEST: {
                return 10;
            }
            case WEST_SOUTH_WEST: {
                return 11;
            }
            case WEST: {
                return 12;
            }
            case WEST_NORTH_WEST: {
                return 13;
            }
            case NORTH_WEST: {
                return 14;
            }
            case NORTH_NORTH_WEST: {
                return 15;
            }
        }
        return -1;
    }

    public static BlockFace fromRotation(int r) {
        switch (FastMath.floorMod(r, 16)) {
            case 0: {
                return BlockFace.NORTH;
            }
            case 1: {
                return BlockFace.NORTH_NORTH_EAST;
            }
            case 2: {
                return BlockFace.NORTH_EAST;
            }
            case 3: {
                return BlockFace.EAST_NORTH_EAST;
            }
            case 4: {
                return BlockFace.EAST;
            }
            case 5: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case 6: {
                return BlockFace.SOUTH_EAST;
            }
            case 7: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
            case 8: {
                return BlockFace.SOUTH;
            }
            case 9: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case 10: {
                return BlockFace.SOUTH_WEST;
            }
            case 11: {
                return BlockFace.WEST_SOUTH_WEST;
            }
            case 12: {
                return BlockFace.WEST;
            }
            case 13: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case 14: {
                return BlockFace.NORTH_WEST;
            }
            case 15: {
                return BlockFace.NORTH_NORTH_WEST;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Axis getRotatedAxis(Axis orig, Rotation r) {
        Axis other = orig;
        boolean shouldSwitch = r.equals((Object)Rotation.CW_90) || r.equals((Object)Rotation.CCW_90);
        switch (orig) {
            case X: {
                if (!shouldSwitch) break;
                other = Axis.Z;
                break;
            }
            case Z: {
                if (!shouldSwitch) break;
                other = Axis.X;
            }
        }
        return other;
    }

    public static Rail.Shape getRotatedRail(Rail.Shape orig, Rotation r) {
        switch (r) {
            case CCW_90: {
                switch (orig) {
                    case NORTH_WEST: {
                        return Rail.Shape.SOUTH_WEST;
                    }
                    case NORTH_SOUTH: {
                        return Rail.Shape.EAST_WEST;
                    }
                    case SOUTH_WEST: {
                        return Rail.Shape.SOUTH_EAST;
                    }
                    case SOUTH_EAST: {
                        return Rail.Shape.NORTH_EAST;
                    }
                    case EAST_WEST: {
                        return Rail.Shape.NORTH_SOUTH;
                    }
                    case NORTH_EAST: {
                        return Rail.Shape.NORTH_WEST;
                    }
                    case ASCENDING_EAST: {
                        return Rail.Shape.ASCENDING_NORTH;
                    }
                    case ASCENDING_WEST: {
                        return Rail.Shape.ASCENDING_SOUTH;
                    }
                    case ASCENDING_NORTH: {
                        return Rail.Shape.ASCENDING_WEST;
                    }
                    case ASCENDING_SOUTH: {
                        return Rail.Shape.ASCENDING_EAST;
                    }
                }
            }
            case CW_90: {
                switch (orig) {
                    case NORTH_WEST: {
                        return Rail.Shape.NORTH_EAST;
                    }
                    case NORTH_SOUTH: {
                        return Rail.Shape.EAST_WEST;
                    }
                    case SOUTH_WEST: {
                        return Rail.Shape.NORTH_WEST;
                    }
                    case SOUTH_EAST: {
                        return Rail.Shape.SOUTH_WEST;
                    }
                    case EAST_WEST: {
                        return Rail.Shape.NORTH_SOUTH;
                    }
                    case NORTH_EAST: {
                        return Rail.Shape.SOUTH_EAST;
                    }
                    case ASCENDING_EAST: {
                        return Rail.Shape.ASCENDING_SOUTH;
                    }
                    case ASCENDING_WEST: {
                        return Rail.Shape.ASCENDING_NORTH;
                    }
                    case ASCENDING_NORTH: {
                        return Rail.Shape.ASCENDING_EAST;
                    }
                    case ASCENDING_SOUTH: {
                        return Rail.Shape.ASCENDING_WEST;
                    }
                }
            }
            case CW_180: {
                switch (orig) {
                    case NORTH_WEST: {
                        return Rail.Shape.SOUTH_EAST;
                    }
                    case NORTH_SOUTH: {
                        return Rail.Shape.NORTH_SOUTH;
                    }
                    case SOUTH_WEST: {
                        return Rail.Shape.NORTH_EAST;
                    }
                    case SOUTH_EAST: {
                        return Rail.Shape.NORTH_WEST;
                    }
                    case EAST_WEST: {
                        return Rail.Shape.EAST_WEST;
                    }
                    case NORTH_EAST: {
                        return Rail.Shape.SOUTH_WEST;
                    }
                    case ASCENDING_EAST: {
                        return Rail.Shape.ASCENDING_WEST;
                    }
                    case ASCENDING_WEST: {
                        return Rail.Shape.ASCENDING_EAST;
                    }
                    case ASCENDING_NORTH: {
                        return Rail.Shape.ASCENDING_SOUTH;
                    }
                    case ASCENDING_SOUTH: {
                        return Rail.Shape.ASCENDING_NORTH;
                    }
                }
            }
        }
        return orig;
    }

    public static void rotateBlockData(BlockData data, Rotation r) {
        block7: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block6: {
                                    if (!(data instanceof Rotatable)) break block6;
                                    BlockFace rt = RotationUtil.getRotatedFace(((Rotatable)data).getRotation(), r);
                                    ((Rotatable)data).setRotation(rt);
                                    break block7;
                                }
                                if (!(data instanceof Directional)) break block8;
                                BlockFace rt = RotationUtil.getRotatedFace(((Directional)data).getFacing(), r);
                                ((Directional)data).setFacing(rt);
                                break block7;
                            }
                            if (!(data instanceof MultipleFacing)) break block9;
                            MultipleFacing mfData = (MultipleFacing)data;
                            EnumMap<BlockFace, Boolean> faces = new EnumMap<BlockFace, Boolean>(BlockFace.class);
                            for (BlockFace blockFace : mfData.getAllowedFaces()) {
                                faces.put(blockFace, mfData.hasFace(blockFace));
                            }
                            for (Map.Entry entry : faces.entrySet()) {
                                mfData.setFace(RotationUtil.getRotatedFace((BlockFace)((Object)entry.getKey()), r), (Boolean)entry.getValue());
                            }
                            break block7;
                        }
                        if (!(data instanceof Rail)) break block10;
                        Rail.Shape newShape = RotationUtil.getRotatedRail(((Rail)data).getShape(), r);
                        ((Rail)data).setShape(newShape);
                        break block7;
                    }
                    if (!(data instanceof Orientable)) break block11;
                    Axis newAxis = RotationUtil.getRotatedAxis(((Orientable)data).getAxis(), r);
                    ((Orientable)data).setAxis(newAxis);
                    break block7;
                }
                if (!(data instanceof RedstoneWire)) break block12;
                EnumMap<BlockFace, RedstoneWire.Connection> connections = new EnumMap<BlockFace, RedstoneWire.Connection>(BlockFace.class);
                RedstoneWire rData = (RedstoneWire)data;
                for (BlockFace blockFace : rData.getAllowedFaces()) {
                    connections.put(blockFace, rData.getFace(blockFace));
                }
                for (Map.Entry entry : connections.entrySet()) {
                    rData.setFace(RotationUtil.getRotatedFace((BlockFace)((Object)entry.getKey()), r), (RedstoneWire.Connection)((Object)entry.getValue()));
                }
                break block7;
            }
            if (!(data instanceof Wall)) break block7;
            Wall wallData = (Wall)data;
            EnumMap<BlockFace, Wall.Height> faces = new EnumMap<BlockFace, Wall.Height>(BlockFace.class);
            for (BlockFace blockFace : CARDINALS) {
                faces.put(blockFace, wallData.getHeight(blockFace));
            }
            for (Map.Entry entry : faces.entrySet()) {
                wallData.setHeight(RotationUtil.getRotatedFace((BlockFace)((Object)entry.getKey()), r), (Wall.Height)((Object)entry.getValue()));
            }
        }
    }
}

