/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.structure.buffer;

import com.dfsek.terra.api.math.vector.Location;
import com.dfsek.terra.api.structures.structure.buffer.Buffer;
import com.dfsek.terra.api.structures.structure.buffer.items.BufferedItem;
import java.util.LinkedHashMap;
import java.util.Map;

public class DirectBuffer
implements Buffer {
    private final Location origin;
    private final Map<Location, String> marks = new LinkedHashMap<Location, String>();

    public DirectBuffer(Location origin) {
        this.origin = origin;
    }

    @Override
    public Buffer addItem(BufferedItem item, Location location) {
        item.paste(this.origin.clone().add(location));
        return this;
    }

    @Override
    public Location getOrigin() {
        return this.origin;
    }

    @Override
    public String getMark(Location location) {
        return this.marks.get(location);
    }

    @Override
    public Buffer setMark(String mark, Location location) {
        this.marks.put(location, mark);
        return this;
    }
}

