/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.structure.buffer;

import com.dfsek.terra.api.math.vector.Location;
import com.dfsek.terra.api.math.vector.Vector3;
import com.dfsek.terra.api.structures.structure.buffer.Buffer;
import com.dfsek.terra.api.structures.structure.buffer.items.BufferedItem;

public class IntermediateBuffer
implements Buffer {
    private final Buffer original;
    private final Vector3 offset;

    public IntermediateBuffer(Buffer original, Vector3 offset) {
        this.original = original;
        this.offset = offset.clone();
    }

    @Override
    public Buffer addItem(BufferedItem item, Location location) {
        return this.original.addItem(item, location.add(this.offset));
    }

    @Override
    public Location getOrigin() {
        return this.original.getOrigin().clone().add(this.offset);
    }

    @Override
    public String getMark(Location location) {
        return this.original.getMark(location.add(this.offset));
    }

    @Override
    public Buffer setMark(String mark, Location location) {
        this.original.setMark(mark, location.add(this.offset));
        return this;
    }
}

