/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.structure.buffer;

import com.dfsek.terra.api.math.vector.Location;
import com.dfsek.terra.api.platform.world.Chunk;
import com.dfsek.terra.api.structures.structure.buffer.Buffer;
import com.dfsek.terra.api.structures.structure.buffer.Cell;
import com.dfsek.terra.api.structures.structure.buffer.items.BufferedItem;
import com.dfsek.terra.lib.jafama.FastMath;
import java.util.LinkedHashMap;
import java.util.Map;

public class StructureBuffer
implements Buffer {
    private final Map<Location, Cell> bufferedItemMap = new LinkedHashMap<Location, Cell>();
    private final Location origin;
    private boolean succeeded;

    public StructureBuffer(Location origin) {
        this.origin = origin;
    }

    public void paste() {
        this.bufferedItemMap.forEach((vector3, item) -> item.paste(this.origin.clone().add((Location)vector3)));
    }

    public void paste(Chunk chunk) {
        this.bufferedItemMap.forEach((location, item) -> {
            Location current = this.origin.clone().add((Location)location);
            if (FastMath.floorDiv(current.getBlockX(), 16) != chunk.getX() || FastMath.floorDiv(current.getBlockZ(), 16) != chunk.getZ()) {
                return;
            }
            item.paste(chunk, current);
        });
    }

    @Override
    public Buffer addItem(BufferedItem item, Location location) {
        this.bufferedItemMap.computeIfAbsent(location, l -> new Cell()).add(item);
        return this;
    }

    @Override
    public String getMark(Location location) {
        Cell cell = this.bufferedItemMap.get(location);
        if (cell != null) {
            return cell.getMark();
        }
        return null;
    }

    @Override
    public Buffer setMark(String mark, Location location) {
        this.bufferedItemMap.computeIfAbsent(location, l -> new Cell()).setMark(mark);
        return this;
    }

    public void setSucceeded(boolean succeeded) {
        this.succeeded = succeeded;
    }

    public boolean succeeded() {
        return this.succeeded;
    }

    @Override
    public Location getOrigin() {
        return this.origin.clone();
    }
}

